/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.workingset;

import ikr.simtree.base.SimTreeException;
import ikr.simtree.commands.CommandEnum;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.Option;
import ikr.simtree.options.Options;
import ikr.simtree.options.SimulationParameterOption;
import ikr.simtree.options.SimulationParameterPathOption;
import ikr.simtree.resultdef.ResultDef;
import ikr.simtree.resultdef.ResultDefs;
import ikr.simtree.simpara.SimPara;
import ikr.simtree.simpara.SimParaNameAndType;
import ikr.simtree.simpara.SimParaOptions;
import ikr.simtree.simpara.SimParaPath;
import ikr.simtree.simpara.SimParaPathList;
import ikr.simtree.vfs.results.tree.ResultsTreeState;
import ikr.simtree.workingset.WorkDesc;
import ikr.simtree.workingset.WorkItem;
import ikr.simtree.workingset.WorkingSet;
import java.util.Collections;
import java.util.Iterator;

public class WorkingSetBuilder {
    private final Options spOptions;
    private final SimulationParameterPathOption sppOption;
    private final ResultDefs resultDefs;
    private final CommandEnum commandEnum;
    private final boolean useCurrentValuesWhenOptionNotGiven;

    public WorkingSetBuilder(Options spOptions, SimulationParameterPathOption sppOption, ResultDefs resultDefs, CommandEnum commandEnum, boolean useCurrentValuesWhenOptionNotGiven) {
        this.spOptions = spOptions;
        this.sppOption = sppOption;
        this.commandEnum = commandEnum;
        this.useCurrentValuesWhenOptionNotGiven = useCurrentValuesWhenOptionNotGiven;
        this.resultDefs = resultDefs;
    }

    public WorkingSet getWorkingSet(SimTreeContext sc) throws SimTreeException {
        int depth;
        WorkingSet workingSet = new WorkingSet();
        ResultsTreeState.checkTreeConsistency(sc);
        SimParaPathList simParaPathesInCurrentTree = ResultsTreeState.getCurrentTreeContent(sc);
        SimParaPath longestPathInTree = simParaPathesInCurrentTree.getLongestPath();
        SimParaOptions simParaOptions = this.getSimParaOptionsFromCommandline(longestPathInTree);
        assert (simParaOptions.size() >= longestPathInTree.size());
        if (this.commandEnum != CommandEnum.ADD && this.commandEnum != CommandEnum.REMOVE && this.commandEnum != CommandEnum.LIST && longestPathInTree.size() != simParaPathesInCurrentTree.getShortestPath().size()) {
            throw new SimTreeException("Results tree is inconsistent, ensure that all pathes have the same depth");
        }
        if (this.commandEnum == CommandEnum.ADD) {
            depth = 0;
            while (depth < longestPathInTree.size()) {
                if (simParaOptions.get(depth) != null && !((SimulationParameterOption)simParaOptions.get((int)depth)).getValuePatterns().useValuesNotInList) {
                    for (String value : ((SimulationParameterOption)simParaOptions.get(depth)).getValuePatterns().getRawValues()) {
                        SimParaPathList addList = new SimParaPathList();
                        for (SimParaPath existingPath : simParaPathesInCurrentTree) {
                            SimParaPath pathClone = existingPath.clonePath();
                            SimPara paraOld = (SimPara)longestPathInTree.get(depth);
                            SimPara paraNew = new SimPara(new SimParaNameAndType(paraOld.getParaName(), paraOld.getParaType()), value);
                            if (depth < pathClone.size()) {
                                pathClone.set(depth, paraNew);
                            } else {
                                if (depth != pathClone.size()) {
                                    throw new SimTreeException("Cannot handle holes in the simulation parameters when adding values, fill holes first");
                                }
                                pathClone.add(paraNew);
                            }
                            addList.add(pathClone);
                        }
                        for (SimParaPath simParaPath : addList) {
                            simParaPathesInCurrentTree.addWhenUnique(simParaPath);
                        }
                    }
                }
                ++depth;
            }
        }
        depth = 0;
        while (depth < longestPathInTree.size()) {
            Iterator iter = simParaPathesInCurrentTree.iterator();
            while (iter.hasNext()) {
                SimParaPath path = (SimParaPath)iter.next();
                if (!this.matchesConstraint(depth < path.size() ? (SimPara)path.get(depth) : null, (SimulationParameterOption)simParaOptions.get(depth))) continue;
                iter.remove();
            }
            ++depth;
        }
        if (this.commandEnum == CommandEnum.ADD) {
            depth = longestPathInTree.size();
            while (depth < simParaOptions.size()) {
                SimulationParameterOption spOption = (SimulationParameterOption)simParaOptions.get(depth);
                if (spOption.getValuePatterns().useValuesNotInList) {
                    throw new SimTreeException("Cannot handle ! operator for new simulation parameter");
                }
                if (spOption.getValuePatterns().getRawValues().size() == 0) {
                    throw new SimTreeException("Need at least one value for new simulation parameter");
                }
                if (spOption.getParaType() == null) {
                    throw new SimTreeException("Type required for new simulation parameter");
                }
                if (simParaPathesInCurrentTree.size() == 0) {
                    simParaPathesInCurrentTree.add(new SimParaPath());
                }
                SimParaPathList newList = new SimParaPathList();
                for (SimParaPath simParaPath : simParaPathesInCurrentTree) {
                    if (simParaPath.size() < depth) {
                        throw new SimTreeException("Cannot add new simulation parameter when existing paths are not of equal length");
                    }
                    for (String newValue : spOption.getValuePatterns().getRawValues()) {
                        SimParaPath pathClone = simParaPath.clonePath();
                        pathClone.add(new SimPara(new SimParaNameAndType(spOption.getParaName(), spOption.getParaType()), newValue));
                        newList.add(pathClone);
                    }
                }
                simParaPathesInCurrentTree = newList;
                ++depth;
            }
        }
        Collections.sort(simParaPathesInCurrentTree);
        for (SimParaPath simParaPath : simParaPathesInCurrentTree) {
            if (this.resultDefs == null) {
                workingSet.addToWaiting(new WorkItem(workingSet, new WorkDesc(simParaPath)));
                continue;
            }
            for (ResultDef resultDef : this.resultDefs) {
                workingSet.addToWaiting(new WorkItem(workingSet, new WorkDesc(simParaPath, resultDef)));
            }
        }
        return workingSet;
    }

    private SimParaOptions getSimParaOptionsFromCommandline(SimParaPath currentResultsTreeSimParaPath) throws SimTreeException {
        SimParaOptions unsorted = this.sppOption != null ? this.sppOption.getSimParaOptionList(currentResultsTreeSimParaPath) : new SimParaOptions();
        if (this.spOptions != null) {
            for (Option spOpt : this.spOptions) {
                unsorted.add((SimulationParameterOption)spOpt);
            }
        }
        SimParaOptions sorted = new SimParaOptions();
        for (SimPara simPara : currentResultsTreeSimParaPath) {
            boolean found = false;
            Iterator iter = unsorted.iterator();
            while (iter.hasNext()) {
                SimulationParameterOption spo = (SimulationParameterOption)iter.next();
                if (!spo.getParaName().equals(simPara.getParaName())) continue;
                if (spo.getParaType() != null && spo.getParaType() != simPara.getParaType()) {
                    throw new SimTreeException("Invalid type in option for simulation parameter " + spo.getParaName());
                }
                found = true;
                sorted.add(spo);
                iter.remove();
                break;
            }
            if (found) continue;
            sorted.add(null);
        }
        assert (sorted.size() == currentResultsTreeSimParaPath.size());
        if (this.commandEnum == CommandEnum.ADD) {
            sorted.addAll(unsorted);
        } else if (unsorted.size() != 0) {
            throw new SimTreeException("Simulation parameter " + ((SimulationParameterOption)unsorted.get(0)).getParaName() + " not in tree");
        }
        int i = 0;
        while (i < sorted.size()) {
            int j = 0;
            while (j < sorted.size()) {
                if (i != j && sorted.get(i) != null && sorted.get(j) != null && ((SimulationParameterOption)sorted.get(i)).getParaName().equals(((SimulationParameterOption)sorted.get(j)).getParaName())) {
                    throw new SimTreeException("Duplicate option for simulation parameter name " + ((SimulationParameterOption)sorted.get(i)).getParaName());
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < currentResultsTreeSimParaPath.size()) {
            assert (((SimPara)currentResultsTreeSimParaPath.get(i)).getParaType() != null);
            if (sorted.get(i) != null) {
                assert (((SimulationParameterOption)sorted.get(i)).getValuePatterns() != null);
                if (((SimulationParameterOption)sorted.get(i)).getParaType() == null) {
                    ((SimulationParameterOption)sorted.get(i)).setType(((SimPara)currentResultsTreeSimParaPath.get(i)).getParaType());
                } else if (((SimulationParameterOption)sorted.get(i)).getParaType() != ((SimPara)currentResultsTreeSimParaPath.get(i)).getParaType()) {
                    throw new SimTreeException("Inconsistent simulation parameter type on depth " + i);
                }
            }
            ++i;
        }
        return sorted;
    }

    private boolean matchesConstraint(SimPara simPara, SimulationParameterOption simParaOption) throws SimTreeException {
        if (simParaOption == null || simParaOption.getValuePatterns().size() == 0) {
            return !this.useCurrentValuesWhenOptionNotGiven;
        }
        if (simPara == null) {
            return true;
        }
        return simParaOption.getValuePatterns().matches(simPara);
    }
}

