/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.workingset;

import ikr.simtree.base.SHelpers;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.Strings;
import ikr.simtree.workingset.WorkDescs;
import ikr.simtree.workingset.WorkItem;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class WorkingSet {
    private final LinkedList<WorkItem> waitingList = new LinkedList();
    private final LinkedList<WorkItem> runningList = new LinkedList();
    private final LinkedList<WorkItem> finishedList = new LinkedList();

    protected synchronized void addToWaiting(WorkItem workItem) {
        assert (workItem != null);
        this.waitingList.add(workItem);
    }

    public synchronized WorkItem getNextWaitingAndMoveFromWaitingToRunning() {
        if (this.waitingList.size() == 0) {
            return null;
        }
        WorkItem workItem = this.waitingList.removeFirst();
        assert (workItem != null);
        this.runningList.add(workItem);
        return workItem;
    }

    public synchronized boolean isWaitingEmpty() {
        return this.waitingList.size() == 0;
    }

    protected synchronized void moveFromRunningToFinished(WorkItem workItem) {
        assert (workItem != null);
        this.runningList.remove(workItem);
        this.finishedList.addLast(workItem);
    }

    private static Strings toDisplayStrings(List<WorkItem> list, String title) {
        Strings ret = new Strings();
        ret.add(title);
        if (list.isEmpty()) {
            ret.add(String.valueOf(SHelpers.indent(1)) + "List is empty");
        } else {
            for (WorkItem workItem : list) {
                ret.addAll(workItem.getInfoStrings(1));
            }
        }
        return ret;
    }

    public synchronized Strings toDisplayStringsWaiting() {
        return WorkingSet.toDisplayStrings(this.waitingList, "Waiting");
    }

    public synchronized Strings toDisplayStringsRunning() {
        return WorkingSet.toDisplayStrings(this.runningList, "Running");
    }

    public synchronized Strings toDisplayStringsFinished() {
        return WorkingSet.toDisplayStrings(this.finishedList, "Finished");
    }

    public synchronized WorkDescs merge(WorkingSet otherWorkingSet) throws SimTreeException {
        WorkDescs ret = new WorkDescs();
        for (WorkItem newWorkItem : otherWorkingSet.waitingList) {
            boolean found = false;
            for (WorkItem workItem : this.waitingList) {
                if (!workItem.workDesc.matches(newWorkItem.workDesc, false)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.addToWaiting(newWorkItem);
            ret.add(newWorkItem.workDesc);
        }
        return ret;
    }

    public synchronized WorkDescs subtract(WorkingSet otherWorkingSet) throws SimTreeException {
        WorkDescs ret = new WorkDescs();
        Iterator iter = this.waitingList.iterator();
        block0: while (iter.hasNext()) {
            WorkItem workItem = (WorkItem)iter.next();
            for (WorkItem newWorkItem : otherWorkingSet.waitingList) {
                if (!workItem.workDesc.matches(newWorkItem.workDesc, true)) continue;
                iter.remove();
                ret.add(workItem.workDesc);
                continue block0;
            }
        }
        return ret;
    }
}

