/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.workingset;

import ikr.simtree.base.SHelpers;
import ikr.simtree.base.Strings;
import ikr.simtree.workingset.WorkDesc;
import ikr.simtree.workingset.WorkItemInfo;
import ikr.simtree.workingset.WorkingSet;
import java.util.ArrayList;
import java.util.List;

public class WorkItem {
    private final WorkingSet workingSet;
    public final WorkDesc workDesc;
    private final List<WorkItemInfo> workItemInfos = new ArrayList<WorkItemInfo>();

    public WorkItem(WorkingSet workingSet, WorkDesc workDesc) {
        assert (workDesc != null);
        assert (workingSet != null);
        this.workDesc = workDesc;
        this.workingSet = workingSet;
    }

    public synchronized void fromRunningToFinished() {
        this.workingSet.moveFromRunningToFinished(this);
    }

    public synchronized void addInfo(WorkItemInfo workItemInfo) {
        assert (workItemInfo != null);
        this.workItemInfos.add(workItemInfo);
    }

    protected synchronized Strings getInfoStrings(int indent) {
        Strings ret = new Strings();
        String shortString = String.valueOf(SHelpers.indent(indent)) + this.workDesc.toFormattedString();
        Strings longInfo = new Strings();
        for (WorkItemInfo info : this.workItemInfos) {
            if (info.isCoreInfo() && info.getWorkItemInfo().size() != 0) {
                shortString = String.valueOf(shortString) + " " + (String)info.getWorkItemInfo().get(0);
                continue;
            }
            for (String s : info.getWorkItemInfo()) {
                longInfo.add(String.valueOf(SHelpers.indent(indent + 1)) + s);
            }
        }
        ret.add(shortString);
        ret.addAll(longInfo);
        return ret;
    }
}

