/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.vfs.results.tree;

import ikr.simtree.base.FileOPs;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.simpara.SimPara;
import ikr.simtree.simpara.SimParaPath;
import ikr.simtree.simpara.SimParaTypeEnum;
import ikr.simtree.simpara.SimParas;
import ikr.simtree.vfs.results.tree.ResultsTreeState;
import java.io.File;

public class ResultsTreeVFS {
    private final SimParaPath simParaPath;

    public ResultsTreeVFS(SimParaPath simParaPath) {
        this.simParaPath = simParaPath;
    }

    public SimParaPath getPathClone() {
        return this.simParaPath.clonePath();
    }

    protected SimParas listDir() throws SimTreeException {
        File dir = this.simParaPath.toAbsoluteDir();
        if (!dir.isDirectory()) {
            throw new SimTreeException(String.valueOf(dir.getAbsolutePath()) + " is not a directory");
        }
        String[] dirContent = FileOPs.listDir(dir);
        SimParas ret = new SimParas();
        String paraName = null;
        SimParaTypeEnum paraType = null;
        String[] stringArray = dirContent;
        int n = dirContent.length;
        int n2 = 0;
        while (n2 < n) {
            String dirEntry = stringArray[n2];
            boolean validName = true;
            SimPara para = null;
            try {
                para = new SimPara(dirEntry);
            }
            catch (SimTreeException e) {
                validName = false;
            }
            if (validName) {
                assert (para != null);
                if (paraName == null) {
                    paraName = para.getParaName();
                } else if (!paraName.equals(para.getParaName())) {
                    throw new SimTreeException("Wrong parameter entry " + para.toFormattedString(SimPara.FormatEnum.PLAIN) + " in directory " + this.simParaPath.toAbsoluteDirName());
                }
                if (paraType == null) {
                    paraType = para.getParaType();
                } else if (paraType != para.getParaType()) {
                    throw new SimTreeException("Wrong type for parameter " + paraName + " in directory " + this.simParaPath.toAbsoluteDirName());
                }
                ret.add(para);
            }
            ++n2;
        }
        return ret;
    }

    private boolean containsDirOnlySimParaEntries() throws SimTreeException {
        File simParaPathDir = this.simParaPath.toAbsoluteDir();
        if (!simParaPathDir.isDirectory()) {
            return true;
        }
        String[] dirContent = FileOPs.listDir(simParaPathDir);
        return dirContent.length == this.listDir().size();
    }

    public int rmDir() throws SimTreeException {
        ResultsTreeState.stateSimulationParametersWereModified();
        return FileOPs.rmDir(this.simParaPath.toAbsoluteDirName());
    }

    public int mkDirs() throws SimTreeException {
        if (this.simParaPath.size() != 0) {
            SimParaPath simParaPathClone = this.simParaPath.clonePath();
            while (simParaPathClone.size() >= 1) {
                simParaPathClone.remove(simParaPathClone.size() - 1);
                if (new ResultsTreeVFS(simParaPathClone).containsDirOnlySimParaEntries()) continue;
                throw new SimTreeException("Cannot create simulation parameter path, parent dir contains invalid entries");
            }
        }
        ResultsTreeState.stateSimulationParametersWereModified();
        return FileOPs.mkDirs(this.simParaPath.toAbsoluteDirName());
    }
}

