/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.vfs.results.node;

import ikr.simtree.base.FileOPs;
import ikr.simtree.base.Integers;
import ikr.simtree.base.Props;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.StringContainer;
import ikr.simtree.base.Strings;
import ikr.simtree.commands.CommandEnum;
import ikr.simtree.eval.ResultFile;
import ikr.simtree.eval.ResultFiles;
import ikr.simtree.hooks.HookFileCreator;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.parafile.AttributesLists;
import ikr.simtree.parafile.ParaFileCreator;
import ikr.simtree.resultdef.ResultDef;
import ikr.simtree.resultdef.ResultDefs;
import ikr.simtree.resultdef.SeedDef;
import ikr.simtree.resultdef.SeedDefs;
import ikr.simtree.resultdef.SimulateBatchesResultDef;
import ikr.simtree.resultdef.SimulateDropResultDef;
import ikr.simtree.resultdef.SingleRunResultDef;
import ikr.simtree.simpara.SimParaPath;
import ikr.simtree.vfs.StudyRootVFS;
import ikr.simtree.vfs.results.node.NumberedDirEntries;
import ikr.simtree.vfs.results.node.NumberedDirEntry;
import ikr.simtree.vfs.results.node.PackedFile;
import ikr.simtree.vfs.results.node.ResultFileName;
import ikr.simtree.vfs.results.node.ResultNodeContent;
import ikr.simtree.vfs.results.node.SimulationMethodEnum;
import ikr.simtree.vfs.results.tree.ResultsTreeState;
import java.io.File;
import java.io.IOException;

public class ResultNodeVFS {
    private static final String FNAME_LOCKFILE = "simtree.lock";
    private static final String FNAME_PARAMFILE = Props.getStr("st.s.parameter_filename.1");
    private static final String FNAME_PARSER_LOGFILE = Props.getStr("st.s.parser_log_filename.1");
    private static final String SEED_FNAME_BASE = "Seed";
    private static final String BM_BATCH_FNAME_BASE = "Batch";
    private static final String BM_BATCHES_DIR = "Batches";
    private static final String BM_EXPORTS_DIR = "Exports";
    private static final String IR_DROP_FNAME = "Drop";
    private static final String IR_EXPORT_FNAME = "Export";
    private static final String SEP = File.separator;
    private final SimParaPath simParaPath;
    private final String pathAbsDir;
    private final SimTreeContext sc;
    private SimulationMethodEnum simulationMethod = null;

    public ResultNodeVFS(SimParaPath simParaPath, SimTreeContext sc) {
        this.simParaPath = simParaPath;
        this.pathAbsDir = simParaPath.toAbsoluteDirName();
        this.sc = sc;
    }

    public SimParaPath getSimParaPath() {
        return this.simParaPath;
    }

    public File getFinalResultsFile() {
        return ResultFileName.getFinalResultFile(this.pathAbsDir, this.sc);
    }

    public boolean isEmpty() throws SimTreeException {
        return FileOPs.listDir(this.pathAbsDir).length == 0;
    }

    public ResultNodeContent getResultNodeContent() throws SimTreeException {
        ResultNodeContent resultNodeContent = new ResultNodeContent();
        boolean presetDirNotEmptyWarning = true;
        if (this.isLocked((SeedDef)null)) {
            resultNodeContent.isLocked = true;
            presetDirNotEmptyWarning = false;
        }
        if (this.getFinalResultsFile() != null) {
            resultNodeContent.finalResultFileExist = true;
            presetDirNotEmptyWarning = false;
        }
        for (SeedDef seedDef : this.getExistingSeeds()) {
            if (!this.isLocked(seedDef)) continue;
            resultNodeContent.lockedSeeds.add(seedDef);
            presetDirNotEmptyWarning = false;
        }
        resultNodeContent.defaultBatches = this.getExistingDefaultBatches();
        resultNodeContent.seededBatches = this.getExistingSeededResults(false);
        resultNodeContent.exportResults = this.getExistingSeededResults(true);
        if (resultNodeContent.defaultBatches.size() != 0 || resultNodeContent.seededBatches.size() != 0 || resultNodeContent.exportResults.size() != 0) {
            presetDirNotEmptyWarning = false;
        }
        resultNodeContent.isDirEmpty = this.isEmpty();
        resultNodeContent.mayContainForeignFiles = presetDirNotEmptyWarning && !resultNodeContent.isDirEmpty;
        return resultNodeContent;
    }

    public boolean isLocked(ResultDef resultDef) throws SimTreeException {
        return this.isLocked(ResultNodeVFS.result2seed(resultDef));
    }

    public String getAbsWorkingDirName(ResultDef resultDef) throws SimTreeException {
        return this.getAbsWorkingDirName(ResultNodeVFS.result2seed(resultDef));
    }

    public int unlockAllExistingResults() throws SimTreeException {
        int i = 0;
        for (SeedDef seedDef : this.getExistingSeeds()) {
            i += this.unlockDir(seedDef);
        }
        return i += this.unlockDir(null);
    }

    public boolean removeAllExistingResults() throws SimTreeException {
        boolean ret = true;
        for (SeedDef seedDef : this.getExistingSeeds()) {
            if (this.iRemoveResult(seedDef)) continue;
            ret = false;
        }
        if (!this.iRemoveResult(null)) {
            ret = false;
        }
        return ret;
    }

    public ResultFiles getExistingResultFiles(ResultDefs resultDefs) throws SimTreeException {
        ResultFiles ret = new ResultFiles();
        this.setSimulationMethod(null, false);
        if (this.simulationMethod == null) {
            return ret;
        }
        for (ResultDef resultDef : resultDefs) {
            if (this.isBM()) {
                for (NumberedDirEntry resultEntry : this.getExistingBMPartTestNumberEntries(resultDef, false)) {
                    int batchNum = resultEntry.number;
                    if (!resultDef.containsPartTestNum(batchNum)) continue;
                    File file = new File(resultEntry.fullPath);
                    assert (file.exists());
                    ret.add(new ResultFile(file, new SingleRunResultDef(resultDef, batchNum)));
                }
                continue;
            }
            for (NumberedDirEntry resultEntry : new NumberedDirEntries(this.pathAbsDir, SEED_FNAME_BASE, true, this.sc)) {
                String fname;
                int seedNum = resultEntry.number;
                if (resultDef.getSeedDef().seedNum != seedNum || (fname = ResultFileName.findResultFile(resultEntry.fullPath, IR_DROP_FNAME)) == null) continue;
                File file = new File(String.valueOf(resultEntry.fullPath) + SEP + fname);
                assert (file.exists());
                ret.add(new ResultFile(file, new SingleRunResultDef(resultDef, 1)));
            }
        }
        return ret;
    }

    public boolean completelyCleanDirectory() throws SimTreeException {
        if (!this.removeAllExistingResults()) {
            return false;
        }
        FileOPs.cleanDirRecursively(this.pathAbsDir);
        return true;
    }

    public SimulationMethodEnum detectSimulationMethod() throws SimTreeException {
        SimulationMethodEnum ret = null;
        String[] stringArray = FileOPs.listDir(this.pathAbsDir);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String dirEntry = stringArray[n2];
            if (dirEntry.equals(BM_BATCHES_DIR) && FileOPs.isDir(String.valueOf(this.pathAbsDir) + SEP + dirEntry)) {
                ret = ResultNodeVFS.iCheckSimulationMethodFound(ret, SimulationMethodEnum.BATCH_MEAN, this.simParaPath);
            }
            ++n2;
        }
        for (NumberedDirEntry numberedDirEntry : new NumberedDirEntries(this.pathAbsDir, SEED_FNAME_BASE, true, this.sc)) {
            String[] stringArray2 = FileOPs.listDir(numberedDirEntry.fullPath);
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String subDirEntry = stringArray2[n4];
                if (ResultFileName.isValidResultFileName(subDirEntry, IR_DROP_FNAME) || ResultFileName.isValidResultFileName(subDirEntry, IR_EXPORT_FNAME)) {
                    ret = ResultNodeVFS.iCheckSimulationMethodFound(ret, SimulationMethodEnum.INDEPENDENT_REPLICATION, this.simParaPath);
                }
                if (subDirEntry.equals(BM_BATCHES_DIR) || subDirEntry.equals(BM_EXPORTS_DIR)) {
                    ret = ResultNodeVFS.iCheckSimulationMethodFound(ret, SimulationMethodEnum.BATCH_MEAN, this.simParaPath);
                }
                ++n4;
            }
        }
        return ret;
    }

    public void prepareExecutionEnvironment(CommandEnum command, String paramFileTemplateName, String filterFileName, AttributesLists attributesLists, ResultDef resultDef, String simulationBinaryPath) throws SimTreeException {
        FileOPs.mkDirs(this.getAbsWorkingDirName(resultDef));
        if (!this.lockDir(ResultNodeVFS.result2seed(resultDef))) {
            throw new SimTreeException("Working directory is locked");
        }
        String absBaseDir = String.valueOf(this.getAbsWorkingDirName(resultDef)) + SEP;
        assert (new File(absBaseDir).exists() && new File(absBaseDir).isDirectory());
        String absParaFileName = String.valueOf(absBaseDir) + FNAME_PARAMFILE;
        Strings createdPartialResultFileRelFileNameList = new Strings(20);
        Strings createdExportResultFileRelFileNameList = new Strings(20);
        Strings importedResultFilesRelFileNameList = new Strings(20);
        String commandFileName = String.valueOf(this.getAbsWorkingDirName(resultDef)) + File.separator + "simtree-callsim";
        try {
            HookFileCreator callsimHookFileWriter = new HookFileCreator("simtree-callsim", commandFileName);
            callsimHookFileWriter.addBooleanPropsReplacements(new String[]{"st.b.compress_result_files_by_simtree.1", "st.b.compress_result_files_by_simlib.1", "st.b.delete_export_result_files_after_collect.1"});
            callsimHookFileWriter.addStringPropsReplacements(new String[]{"st.s.parser_log_filename.1"});
            callsimHookFileWriter.addIntegerPropsReplacements(new String[]{"st.i.callsim_nice_level.1"});
            callsimHookFileWriter.addStringReplacement("FILTER_FILENAME", filterFileName);
            callsimHookFileWriter.addStringReplacement("LOCK_FILENAME", FNAME_LOCKFILE);
            callsimHookFileWriter.addStringReplacement("COMPRESSION_METHOD", "" + Props.getInt("st.i.compression_method.1"));
            callsimHookFileWriter.addStringReplacement("SEED_VALUE", "");
            switch (command) {
                case SIMULATE: {
                    callsimHookFileWriter.addStringReplacement("SIMULATION_PARAMETER_FILENAME", FNAME_PARAMFILE);
                    callsimHookFileWriter.addStringReplacement("NUM_BATCHES", "" + resultDef.getPartTestCount());
                    this.cleanResultsDir(ResultNodeVFS.result2seed(resultDef));
                    ResultFileName.removeFinalResultsFile(this.pathAbsDir);
                    if (resultDef.isDefaultBatch()) {
                        FileOPs.mkDirs(String.valueOf(absBaseDir) + BM_BATCHES_DIR);
                        ParaFileCreator.createParaFile(paramFileTemplateName, absParaFileName, this.simParaPath, attributesLists);
                        if (Props.getBool("st.b.create_default_batches_result_files.1")) {
                            int i = 0;
                            while (i < resultDef.getPartTestCount()) {
                                createdPartialResultFileRelFileNameList.add(BM_BATCHES_DIR + SEP + ResultNodeVFS.getRelBatchFileNameForCreation(resultDef.getPartTestNumFromIndex(i)));
                                ++i;
                            }
                        }
                        callsimHookFileWriter.addStringReplacement("FINAL_RESULT_FILENAME", ResultFileName.getFinalResultRelFileNameForNewFiles());
                    } else {
                        int i;
                        this.setSimulationMethod(resultDef, true);
                        if (this.isBM()) {
                            FileOPs.mkDirs(String.valueOf(absBaseDir) + BM_BATCHES_DIR);
                            FileOPs.mkDirs(String.valueOf(absBaseDir) + BM_EXPORTS_DIR);
                        }
                        ParaFileCreator.createParaFile(paramFileTemplateName, absParaFileName, this.simParaPath, attributesLists);
                        assert (new File(absBaseDir).exists() && new File(absBaseDir).isDirectory());
                        if (this.isBM()) {
                            i = 0;
                            while (i < resultDef.getPartTestCount()) {
                                createdExportResultFileRelFileNameList.add(BM_EXPORTS_DIR + SEP + ResultNodeVFS.getRelBatchFileNameForCreation(resultDef.getPartTestNumFromIndex(i)));
                                ++i;
                            }
                        } else {
                            createdExportResultFileRelFileNameList.add(IR_EXPORT_FNAME + ResultFileName.getResultFileExtensionForNewFiles());
                        }
                        if (this.isBM()) {
                            if (Props.getBool("st.b.create_seeded_batches_result_files.1")) {
                                i = 0;
                                while (i < resultDef.getPartTestCount()) {
                                    createdPartialResultFileRelFileNameList.add(BM_BATCHES_DIR + SEP + ResultNodeVFS.getRelBatchFileNameForCreation(resultDef.getPartTestNumFromIndex(i)));
                                    ++i;
                                }
                            }
                        } else if (Props.getBool("st.b.create_drop_result_files.1")) {
                            createdPartialResultFileRelFileNameList.add(IR_DROP_FNAME + ResultFileName.getResultFileExtensionForNewFiles());
                        }
                        callsimHookFileWriter.addStringReplacement("SEED_VALUE", "" + resultDef.getSeedDef().seedNum);
                        callsimHookFileWriter.addStringReplacement("FINAL_RESULT_FILENAME", "none");
                    }
                    Strings batchesOptionConfigArgList = new Strings();
                    batchesOptionConfigArgList.add(resultDef.getOptionArgumentString());
                    break;
                }
                case COLLECT: {
                    ResultFileName.removeFinalResultsFile(this.pathAbsDir);
                    assert (resultDef == null);
                    ParaFileCreator.createParaFile(paramFileTemplateName, absParaFileName, this.simParaPath, attributesLists);
                    int batchCount = 0;
                    this.setSimulationMethod(null, true);
                    for (NumberedDirEntry seedEntry : new NumberedDirEntries(this.pathAbsDir, SEED_FNAME_BASE, true, this.sc)) {
                        String seedDir = String.valueOf(seedEntry.fullPath) + SEP;
                        if (this.isBM()) {
                            for (NumberedDirEntry batchEntry : new NumberedDirEntries(String.valueOf(seedDir) + BM_EXPORTS_DIR, BM_BATCH_FNAME_BASE, false, this.sc)) {
                                importedResultFilesRelFileNameList.add(String.valueOf(seedEntry.fullName) + SEP + BM_EXPORTS_DIR + SEP + batchEntry.fullName);
                                ++batchCount;
                            }
                            continue;
                        }
                        String fname = ResultFileName.findResultFile(seedDir, IR_EXPORT_FNAME);
                        if (fname == null) continue;
                        importedResultFilesRelFileNameList.add(String.valueOf(seedEntry.fullName) + SEP + fname);
                        ++batchCount;
                    }
                    if (batchCount != 0) {
                        callsimHookFileWriter.addStringReplacement("NUM_BATCHES", "" + batchCount);
                        callsimHookFileWriter.addStringReplacement("FINAL_RESULT_FILENAME", ResultFileName.getFinalResultRelFileNameForNewFiles());
                        callsimHookFileWriter.addStringReplacement("SIMULATION_PARAMETER_FILENAME", FNAME_PARAMFILE);
                        break;
                    }
                    new File(absParaFileName).delete();
                    throw new SimTreeException("Nothing to do, no results found to collect");
                }
                default: {
                    assert (false);
                    break;
                }
            }
            callsimHookFileWriter.addStringReplacement("SIMULATION_PROGRAM_CALL", simulationBinaryPath);
            callsimHookFileWriter.addStringReplacement("PARTIAL_RESULT_FILENAMES", createdPartialResultFileRelFileNameList.toSingleString());
            callsimHookFileWriter.addStringReplacement("EXPORT_RESULT_FILENAMES", createdExportResultFileRelFileNameList.toSingleString());
            callsimHookFileWriter.addStringReplacement("IMPORTED_RESULT_FILENAMES", importedResultFilesRelFileNameList.toSingleString());
            callsimHookFileWriter.createFile();
            assert (this.isLocked(resultDef));
        }
        catch (SimTreeException e) {
            this.unlockDir(ResultNodeVFS.result2seed(resultDef));
            throw new SimTreeException(e.getMessage());
        }
    }

    public boolean skipSimulate(ResultDef resultDef, StringContainer stringContainer) throws SimTreeException {
        if (!this.isSimulateRequired(resultDef, stringContainer)) {
            return true;
        }
        if (ResultNodeVFS.skipCondition(this.isLocked(resultDef), "Result directory is locked", stringContainer)) {
            return true;
        }
        if (resultDef.isDefaultBatch()) {
            return ResultNodeVFS.skipCondition(this.getExistingSeeds().size() != 0, "seeded results exist", stringContainer);
        }
        return ResultNodeVFS.skipCondition(this.getExistingDefaultBatches().size() != 0, "results for default batches exist", stringContainer);
    }

    public boolean skipCollect(StringContainer statusContainer) throws SimTreeException {
        return ResultNodeVFS.skipCondition(this.isLocked((SeedDef)null), "Result directory is locked", statusContainer) || ResultNodeVFS.skipCondition(this.atLeastOneSeedIsLocked(), "At least one seed is locked", statusContainer) || ResultNodeVFS.skipCondition(this.getExistingSeededResults(true).size() == 0, "no result files exist", statusContainer) || ResultNodeVFS.skipCondition(this.getExistingDefaultBatches().size() != 0, "result files for default batches exist", statusContainer) || ResultNodeVFS.skipCondition(this.getFinalResultsFile() != null, "final results file exists", statusContainer);
    }

    private boolean atLeastOneSeedIsLocked() throws SimTreeException {
        for (SeedDef seedDef : this.getExistingSeeds()) {
            if (!this.isLocked(seedDef)) continue;
            return true;
        }
        return false;
    }

    private boolean isSimulateRequired(ResultDef resultDef, StringContainer stringContainer) throws SimTreeException {
        if (resultDef.isDefaultBatch()) {
            if (this.getFinalResultsFile() == null) {
                return true;
            }
            if (!resultDef.containsIdenticalPartTestNums(this.getExistingDefaultBatchNumberList())) {
                return true;
            }
        } else {
            ResultDefs resultDefs = this.getExistingSeededResults(true);
            ResultDef existingResultDef = null;
            for (ResultDef b : resultDefs) {
                if (b.getSeedDef().seedNum != resultDef.getSeedDef().seedNum) continue;
                existingResultDef = b;
            }
            if (existingResultDef == null) {
                return true;
            }
            if (!resultDef.containsIdenticalPartTestNums(existingResultDef.getPartTestNums())) {
                return true;
            }
        }
        stringContainer.setString("Required results exists");
        return false;
    }

    private static boolean meansDefaultBatch(SeedDef seedDef) {
        return seedDef == null;
    }

    private boolean isLocked(SeedDef seedDef) throws SimTreeException {
        return FileOPs.existsFile(this.absLockFileName(seedDef));
    }

    private static SeedDef result2seed(ResultDef resultDef) {
        if (resultDef == null) {
            return null;
        }
        return resultDef.getSeedDef();
    }

    private String getAbsWorkingDirName(SeedDef seedDef) throws SimTreeException {
        if (ResultNodeVFS.meansDefaultBatch(seedDef)) {
            return this.pathAbsDir;
        }
        String existingDir = new NumberedDirEntries(this.pathAbsDir, SEED_FNAME_BASE, true, this.sc).getExistingEntryBaseName(seedDef.seedNum);
        if (existingDir == null) {
            return String.valueOf(this.pathAbsDir) + SEP + SEED_FNAME_BASE + ResultNodeVFS.getCanonNrForCreation(seedDef.seedNum);
        }
        return String.valueOf(this.pathAbsDir) + SEP + existingDir;
    }

    private static SimulationMethodEnum iCheckSimulationMethodFound(SimulationMethodEnum alreadyFoundMethod, SimulationMethodEnum newFoundMethod, SimParaPath simParaPath) throws SimTreeException {
        if (alreadyFoundMethod != null && alreadyFoundMethod != newFoundMethod) {
            throw new SimTreeException("Result dir for " + simParaPath.toFormattedString() + " is inconsistent, contains fragments of more than one simulation method");
        }
        return newFoundMethod;
    }

    private static boolean skipCondition(boolean condition, String text, StringContainer stringContainer) {
        if (condition) {
            stringContainer.setString(text);
            return true;
        }
        return false;
    }

    private static String getCanonNrForCreation(int nr) {
        assert (nr >= 0);
        return String.format("%02d", nr);
    }

    private static String getRelBatchFileNameForCreation(int batchNum) {
        return BM_BATCH_FNAME_BASE + ResultNodeVFS.getCanonNrForCreation(batchNum) + ResultFileName.getResultFileExtensionForNewFiles();
    }

    private ResultDefs getExistingSeededResults(boolean enumExports) throws SimTreeException {
        ResultDefs ret = new ResultDefs();
        this.setSimulationMethod(null, false);
        if (this.simulationMethod == null) {
            return ret;
        }
        for (NumberedDirEntry seedDirEntry : new NumberedDirEntries(this.pathAbsDir, SEED_FNAME_BASE, true, this.sc)) {
            String fnameBase;
            SeedDef seedDef = new SeedDef(seedDirEntry.number);
            if (this.isBM()) {
                Integers partTests = this.getExistingBMPartTestNumberEntries(new SimulateBatchesResultDef(seedDef, new Integers()), enumExports).getNumbers();
                if (partTests.size() == 0) continue;
                ret.addResultDef(new SimulateBatchesResultDef(seedDef, partTests));
                continue;
            }
            String string = fnameBase = enumExports ? IR_EXPORT_FNAME : IR_DROP_FNAME;
            if (ResultFileName.findResultFile(seedDirEntry.fullPath, fnameBase) == null) continue;
            ret.addResultDef(new SimulateDropResultDef(seedDef));
        }
        return ret;
    }

    private SeedDefs getExistingSeeds() throws SimTreeException {
        SeedDefs ret = new SeedDefs();
        for (NumberedDirEntry seedDirEntry : new NumberedDirEntries(this.pathAbsDir, SEED_FNAME_BASE, true, this.sc)) {
            ret.add(new SeedDef(seedDirEntry.number));
        }
        return ret;
    }

    private void cleanResultsDir(SeedDef seedDef) throws SimTreeException {
        String[] dirContent;
        String baseDir = this.getAbsWorkingDirName(seedDef);
        String fbase = String.valueOf(baseDir) + SEP;
        new PackedFile(String.valueOf(fbase) + "simtree-callsim").remove();
        new PackedFile(String.valueOf(fbase) + FNAME_PARAMFILE).remove();
        new PackedFile(String.valueOf(fbase) + FNAME_PARSER_LOGFILE).remove();
        new PackedFile(String.valueOf(fbase) + Props.getStr("st.s.simprog_redir_filename_base.1") + Props.getStr("st.s.redir_out_filename_ext.1")).remove();
        new PackedFile(String.valueOf(fbase) + Props.getStr("st.s.simprog_redir_filename_base.1") + Props.getStr("st.s.redir_err_filename_ext.1")).remove();
        String[] stringArray = dirContent = FileOPs.listDir(baseDir);
        int n = dirContent.length;
        int n2 = 0;
        while (n2 < n) {
            String fname = stringArray[n2];
            if (fname.startsWith(StudyRootVFS.getFileBasenameWithDash()) && (fname.contains(Props.getStr("st.s.redir_out_filename_ext.1")) || fname.contains(Props.getStr("st.s.redir_err_filename_ext.1")))) {
                new PackedFile(String.valueOf(fbase) + fname).remove();
            }
            ++n2;
        }
        new PackedFile(String.valueOf(fbase) + ResultNodeVFS.getRelConfigFileName(CommandEnum.SIMULATE)).remove();
        new PackedFile(String.valueOf(fbase) + ResultNodeVFS.getRelConfigFileName(CommandEnum.COLLECT)).remove();
        new PackedFile(String.valueOf(fbase) + "simtree-time.tmp").remove();
        ResultFileName.removeFinalResultsFile(this.pathAbsDir);
        ResultNodeVFS.removeSubdirWithResultFiles(baseDir, BM_BATCHES_DIR, BM_BATCH_FNAME_BASE);
        ResultNodeVFS.removeSubdirWithResultFiles(baseDir, BM_EXPORTS_DIR, BM_BATCH_FNAME_BASE);
        ResultFileName.removeResultFile(String.valueOf(fbase) + IR_DROP_FNAME);
        ResultFileName.removeResultFile(String.valueOf(fbase) + IR_EXPORT_FNAME);
        if (!ResultNodeVFS.meansDefaultBatch(seedDef)) {
            FileOPs.rmDir(baseDir);
        }
    }

    private static void removeSubdirWithResultFiles(String baseDir, String relSubDirName, String fileNameStart) throws SimTreeException {
        String[] dirContent;
        String subDirName = String.valueOf(baseDir) + SEP + relSubDirName;
        if (!new File(subDirName).exists()) {
            return;
        }
        String[] stringArray = dirContent = FileOPs.listDir(subDirName);
        int n = dirContent.length;
        int n2 = 0;
        while (n2 < n) {
            String dirEntry = stringArray[n2];
            if (ResultFileName.isValidResultFileName(dirEntry, fileNameStart)) {
                FileOPs.rmFile(String.valueOf(subDirName) + SEP + dirEntry);
            }
            ++n2;
        }
        FileOPs.rmDir(subDirName);
    }

    private NumberedDirEntries getExistingBMPartTestNumberEntries(ResultDef resultDef, boolean enumExports) throws SimTreeException {
        return new NumberedDirEntries(String.valueOf(this.getAbsWorkingDirName(resultDef)) + SEP + (enumExports ? BM_EXPORTS_DIR : BM_BATCHES_DIR), BM_BATCH_FNAME_BASE, false, this.sc);
    }

    private Integers getExistingDefaultBatchNumberList() throws SimTreeException {
        return new NumberedDirEntries(String.valueOf(this.pathAbsDir) + SEP + BM_BATCHES_DIR, BM_BATCH_FNAME_BASE, false, this.sc).getNumbers();
    }

    private String absLockFileName(SeedDef seedDef) throws SimTreeException {
        return String.valueOf(this.getAbsWorkingDirName(seedDef)) + SEP + FNAME_LOCKFILE;
    }

    private static String getRelConfigFileName(CommandEnum commandEnum) {
        return String.valueOf(StudyRootVFS.getFileBasenameWithDash()) + commandEnum.commandName + Props.getStr("st.s.config_filename_ext.1");
    }

    private boolean lockDir(SeedDef seedDef) throws SimTreeException {
        String fname = this.absLockFileName(seedDef);
        try {
            return new File(fname).createNewFile();
        }
        catch (IOException e) {
            new File(fname).delete();
            return false;
        }
    }

    private int unlockDir(SeedDef seedDef) throws SimTreeException {
        return FileOPs.rmFile(this.absLockFileName(seedDef));
    }

    private boolean iRemoveResult(SeedDef seedDef) throws SimTreeException {
        if (!this.isLocked(seedDef)) {
            this.cleanResultsDir(seedDef);
            return true;
        }
        return false;
    }

    private ResultDefs getExistingDefaultBatches() throws SimTreeException {
        ResultDefs ret = new ResultDefs();
        Integers batches = this.getExistingDefaultBatchNumberList();
        if (batches.size() != 0) {
            ret.addResultDef(new SimulateBatchesResultDef(batches));
        }
        assert (ret.size() == 0 || ret.size() == 1);
        return ret;
    }

    private void setSimulationMethod(ResultDef resultDef, boolean requireKnown) throws SimTreeException {
        if (this.simulationMethod != null) {
            return;
        }
        SimulationMethodEnum treeSateSimulationMethod = ResultsTreeState.getSimulationMethod(false, this.sc);
        if (resultDef == null) {
            this.simulationMethod = treeSateSimulationMethod;
        } else {
            switch (resultDef.getResultType()) {
                case DEFAULT_BATCHES: 
                case SEEDED_BATCHES: {
                    if (treeSateSimulationMethod == SimulationMethodEnum.INDEPENDENT_REPLICATION) {
                        throw new SimTreeException("Simulation method inconsistent");
                    }
                    this.simulationMethod = SimulationMethodEnum.BATCH_MEAN;
                    break;
                }
                case DROP: {
                    if (treeSateSimulationMethod == SimulationMethodEnum.BATCH_MEAN) {
                        throw new SimTreeException("Simulation method inconsistent");
                    }
                    this.simulationMethod = SimulationMethodEnum.INDEPENDENT_REPLICATION;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        if (this.simulationMethod == null && requireKnown) {
            throw new SimTreeException("Cannot detect simulation method when required");
        }
    }

    private boolean isBM() {
        return this.simulationMethod == SimulationMethodEnum.BATCH_MEAN;
    }
}

