/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.vfs.results.node;

import ikr.simtree.base.FileOPs;
import ikr.simtree.base.Integers;
import ikr.simtree.base.Message;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.vfs.StudyRootVFS;
import ikr.simtree.vfs.results.node.NumberedDirEntry;
import ikr.simtree.vfs.results.node.ResultFileName;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;

public class NumberedDirEntries
extends ArrayList<NumberedDirEntry> {
    private static final String SEP = File.separator;

    protected NumberedDirEntries(String absBaseDirName, String baseName, boolean findDirs, SimTreeContext sc) throws SimTreeException {
        String[] dirContent;
        File baseDir = new File(absBaseDirName);
        assert (absBaseDirName.equals(FileOPs.toAbsolutePath(absBaseDirName)));
        if (!baseDir.exists()) {
            return;
        }
        if (!baseDir.isDirectory()) {
            throw new SimTreeException(baseDir + " exists but is not a directory");
        }
        String[] stringArray = dirContent = FileOPs.listDir(baseDir);
        int n = dirContent.length;
        int n2 = 0;
        while (n2 < n) {
            String dirEntry = stringArray[n2];
            File fullName = new File(String.valueOf(absBaseDirName) + SEP + dirEntry);
            if (findDirs == fullName.isDirectory() && dirEntry.startsWith(baseName)) {
                String entry = dirEntry;
                if (!findDirs) {
                    entry = ResultFileName.getResultFilenameWithoutExtension(entry);
                }
                String warn = "Invalid entry " + dirEntry + " in directory " + StudyRootVFS.reduceName(absBaseDirName);
                if (entry != null && entry.length() > baseName.length()) {
                    int intNum = -1;
                    try {
                        intNum = new Integer(entry.substring(baseName.length()));
                    }
                    catch (NumberFormatException e) {
                        Message.warning(warn, sc);
                    }
                    if (intNum != -1) {
                        this.add(new NumberedDirEntry(intNum, entry, dirEntry, String.valueOf(absBaseDirName) + SEP + dirEntry));
                    }
                } else {
                    Message.warning(warn, sc);
                }
            }
            ++n2;
        }
        Collections.sort(this);
        int i = 0;
        while (i < this.size() - 1) {
            if (((NumberedDirEntry)this.get((int)i)).number == ((NumberedDirEntry)this.get((int)(i + 1))).number) {
                Message.warning("Directory " + StudyRootVFS.reduceName(absBaseDirName) + " contains more than one entry with number " + ((NumberedDirEntry)this.get((int)i)).number + " (may be transient)", sc);
            }
            ++i;
        }
    }

    protected Integers getNumbers() {
        Integers ret = new Integers();
        for (NumberedDirEntry e : this) {
            ret.add(new Integer(e.number));
        }
        return ret;
    }

    protected String getExistingEntryBaseName(int number) {
        for (NumberedDirEntry e : this) {
            if (e.number != number) continue;
            return e.baseName;
        }
        return null;
    }
}

