/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.simpara;

import ikr.simtree.base.SimTreeException;
import ikr.simtree.simpara.SimParaHelpers;
import ikr.simtree.simpara.SimParaTypeEnum;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValuePattern {
    public static final String REGEXP_MARKER = "@";
    private final Matcher matcher;
    private final String rawValue;

    protected ValuePattern(String valueString) throws SimTreeException {
        if (valueString.startsWith(REGEXP_MARKER)) {
            this.matcher = Pattern.compile(valueString.substring(REGEXP_MARKER.length())).matcher("");
            if (this.matcher.groupCount() > 0) {
                throw new SimTreeException("Cannot handle match group in value pattern");
            }
            this.rawValue = null;
        } else {
            this.matcher = null;
            if (!SimParaHelpers.isSimParaValueStringValid(valueString)) {
                throw new SimTreeException("Invalid characters in value pattern");
            }
            this.rawValue = valueString;
        }
    }

    public boolean isRegExp() {
        return this.rawValue == null;
    }

    public String getRawValue() {
        assert (!this.isRegExp());
        return this.rawValue;
    }

    protected synchronized boolean matches(String valueString) {
        return this.matcher.reset(valueString).matches();
    }

    protected void checkValueType(SimParaTypeEnum paraType) throws SimTreeException {
        if (this.isRegExp()) {
            return;
        }
        assert (this.rawValue != null);
        switch (paraType) {
            case INT: {
                try {
                    new Integer(this.rawValue);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new SimTreeException("Invalid number format for integer " + this.rawValue);
                }
            }
            case FLOAT: {
                try {
                    new Double(this.rawValue);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new SimTreeException("Invalid number format for float " + this.rawValue);
                }
            }
            case BOOL: {
                if (this.rawValue.equals("true") || this.rawValue.equals("false")) break;
                throw new SimTreeException("Invalid value for type bool " + this.rawValue);
            }
            case STRING: {
                if (SimParaHelpers.isSimParaValueStringValid(this.rawValue)) break;
                throw new SimTreeException("Invalid value for type string " + this.rawValue);
            }
        }
    }
}

