/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.simpara;

import ikr.simtree.base.SimTreeException;
import ikr.simtree.options.OptionEnum;
import ikr.simtree.simpara.SimParaHelpers;
import ikr.simtree.simpara.SimParaNameAndType;
import ikr.simtree.simpara.SimParaTypeEnum;

public final class SimPara
implements Comparable<SimPara> {
    protected static final String PARA_STRING_SEP = "__";
    private static final String PARA_STRING_PREFIX = "Para";
    private final SimParaNameAndType simParaNameAndType;
    private final String stringValue;
    private int intValue;
    private boolean booleanValue;
    private double doubleValue;

    public SimPara(String composedString) throws SimTreeException {
        String errMsg = "Invalid simulation parameter " + composedString + " ";
        if (!composedString.startsWith(PARA_STRING_PREFIX)) {
            throw new SimTreeException(String.valueOf(errMsg) + "(Invalid prefix)");
        }
        if (composedString.length() < PARA_STRING_PREFIX.length() + 1 + 2 * PARA_STRING_SEP.length() + 2) {
            throw new SimTreeException(String.valueOf(errMsg) + "(Invalid delimiter)");
        }
        SimParaTypeEnum type = null;
        char c = composedString.charAt(PARA_STRING_PREFIX.length());
        SimParaTypeEnum[] simParaTypeEnumArray = SimParaTypeEnum.values();
        int n = simParaTypeEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            SimParaTypeEnum t = simParaTypeEnumArray[n2];
            if (t.charName == c) {
                type = t;
                break;
            }
            ++n2;
        }
        if (type == null) {
            throw new SimTreeException(String.valueOf(errMsg) + "(Invalid type)");
        }
        String rest = composedString.substring(PARA_STRING_PREFIX.length() + 1 + PARA_STRING_SEP.length());
        int e = rest.indexOf(PARA_STRING_SEP);
        if (e == -1) {
            throw new SimTreeException(String.valueOf(errMsg) + "(Missing separator)");
        }
        String paraName = rest.substring(0, e);
        if (!SimParaHelpers.isSimParaNameValid(paraName)) {
            throw new SimTreeException(String.valueOf(errMsg) + "(Name contains invalid characters)");
        }
        if ((rest = rest.substring(e)).length() <= PARA_STRING_SEP.length()) {
            throw new SimTreeException("Missing parameter name");
        }
        this.stringValue = rest.substring(PARA_STRING_SEP.length());
        this.simParaNameAndType = new SimParaNameAndType(paraName, type);
        this.setTypedValues();
    }

    public SimPara(SimParaNameAndType simParaNameAndType, String stringValue) throws SimTreeException {
        this.simParaNameAndType = simParaNameAndType;
        assert (stringValue != null);
        this.stringValue = stringValue;
        this.setTypedValues();
    }

    public SimPara clonePara() {
        try {
            return new SimPara(this.simParaNameAndType.clone(), this.stringValue);
        }
        catch (SimTreeException e) {
            assert (false);
            return null;
        }
    }

    public boolean equals(SimPara other) {
        if (other.getParaType() != this.getParaType()) {
            return false;
        }
        return this.compareTo(other) == 0;
    }

    @Override
    public int compareTo(SimPara other) {
        assert (other.getParaType() == this.getParaType());
        switch (this.simParaNameAndType.paraType) {
            case INT: {
                if (this.intValue == other.intValue) {
                    return 0;
                }
                if (this.intValue < other.intValue) {
                    return -1;
                }
                return 1;
            }
            case FLOAT: {
                if (this.stringValue.equals(other.stringValue)) {
                    return 0;
                }
                if (this.doubleValue < other.doubleValue) {
                    return -1;
                }
                if (this.doubleValue > other.doubleValue) {
                    return 1;
                }
                return 0;
            }
            case STRING: {
                return this.stringValue.compareTo(other.stringValue);
            }
            case BOOL: {
                if (this.booleanValue == other.booleanValue) {
                    return 0;
                }
                if (this.booleanValue) {
                    return -1;
                }
                return 1;
            }
        }
        assert (false);
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValueEqual(String otherStringValue) throws SimTreeException {
        try {
            switch (this.simParaNameAndType.paraType) {
                case INT: {
                    return this.intValue == Integer.valueOf(otherStringValue);
                }
                case FLOAT: {
                    if (this.stringValue.equals(otherStringValue)) {
                        return true;
                    }
                    double otherValue = Double.valueOf(otherStringValue);
                    return !(this.doubleValue < otherValue) && !(this.doubleValue > otherValue);
                }
                case STRING: {
                    return this.stringValue.equals(otherStringValue);
                }
                case BOOL: {
                    return this.booleanValue == Boolean.valueOf(otherStringValue);
                }
            }
            assert (false);
            return false;
        }
        catch (NumberFormatException e) {
            throw new SimTreeException("Invalid value " + this.stringValue + " for type " + (Object)((Object)this.simParaNameAndType.paraType));
        }
    }

    public String getParaName() {
        return this.simParaNameAndType.paraName;
    }

    public SimParaTypeEnum getParaType() {
        return this.simParaNameAndType.paraType;
    }

    public String getTypeName() {
        return this.simParaNameAndType.paraType.typeName;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public String toFormattedString(FormatEnum formatEnum) {
        String paraName = this.simParaNameAndType.paraName;
        assert (paraName != null);
        assert (this.stringValue != null);
        switch (formatEnum) {
            case PLAIN: {
                return "[" + paraName + " " + this.stringValue + "]";
            }
            case OPTION: {
                return String.valueOf(OptionEnum.SIMULATION_PARAMETER.longNameWithStarter) + " " + paraName + " " + this.getTypeName() + " " + this.stringValue;
            }
            case OPTION_SHORT: {
                return String.valueOf(OptionEnum.SIMULATION_PARAMETER.shortNameWithStarter) + " " + paraName + " " + this.getTypeName() + " " + this.stringValue;
            }
            case OPTION_SPP: {
                return this.stringValue;
            }
        }
        return null;
    }

    public String toDirName() {
        String paraName = this.simParaNameAndType.paraName;
        assert (paraName != null && paraName.length() != 0);
        return PARA_STRING_PREFIX + this.simParaNameAndType.paraType.charName + PARA_STRING_SEP + paraName + PARA_STRING_SEP + this.stringValue;
    }

    private void setTypedValues() throws SimTreeException {
        assert (this.stringValue != null);
        try {
            switch (this.simParaNameAndType.paraType) {
                case INT: {
                    this.intValue = Integer.valueOf(this.stringValue);
                    break;
                }
                case FLOAT: {
                    this.doubleValue = Double.valueOf(this.stringValue);
                    break;
                }
                case BOOL: {
                    this.booleanValue = Boolean.valueOf(this.stringValue);
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            throw new SimTreeException("Invalid value " + this.stringValue + " for parameter " + this.simParaNameAndType.paraName);
        }
    }

    public static enum FormatEnum {
        PLAIN,
        OPTION,
        OPTION_SHORT,
        OPTION_SPP;

    }
}

