/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.runsim;

import ikr.simtree.base.Helpers;
import ikr.simtree.base.Message;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.StringPair;
import ikr.simtree.cmdrun.CommandOutputHandler;
import ikr.simtree.cmdrun.CommandRunner;
import ikr.simtree.control.channel.ChannelCommandEnum;
import ikr.simtree.control.channel.ChannelEnum;
import ikr.simtree.hooks.ConditionEnum;
import ikr.simtree.hooks.ConditionNotifyCreator;
import ikr.simtree.hooks.HookFileCreator;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.runsim.ProcessSlot;
import ikr.simtree.simpara.SimParaPath;
import ikr.simtree.workingset.StringWorkItemInfo;
import ikr.simtree.workingset.StringsWorkItemInfo;
import ikr.simtree.workingset.WorkItem;

public class SimThread
implements Runnable {
    private static final String SIMTHREAD_NAME_START = "SimTreeSimThread";
    private final WorkItem workItem;
    private final ProcessSlot slot;
    private final SimTreeContext sc;
    private final String workingDirName;
    private final String cmdLine;
    private final String command;
    private final SimParaPath simParaPath;
    private final boolean isSimTreeParent;

    protected SimThread(WorkItem workItem, ProcessSlot slot, String workingDirName, String command, String cmdLine, SimParaPath simParaPath, boolean isSimTreeParent, SimTreeContext sc) {
        assert (slot != null);
        assert (cmdLine != null);
        assert (command != null && command.length() != 0);
        assert (workingDirName != null);
        assert (workItem != null);
        this.workItem = workItem;
        this.isSimTreeParent = isSimTreeParent;
        this.slot = slot;
        this.workingDirName = workingDirName;
        this.cmdLine = cmdLine;
        this.command = command;
        this.simParaPath = simParaPath;
        this.sc = sc;
        slot.use(workItem.workDesc);
    }

    @Override
    public void run() {
        HookFileCreator hookFileCreator;
        String origCommand = String.valueOf(this.command) + " " + this.cmdLine;
        ConditionNotifyCreator.createAndExecute("st.b.notify_simulation_condition.1", ConditionEnum.SIMULATION_STARTED, this.workingDirName, new StringPair[]{new StringPair("SIMPARA_PATH_STRING", this.simParaPath.toFormattedString()), new StringPair("COMMAND", this.command)}, this.sc);
        if (this.slot.isLocal()) {
            hookFileCreator = new HookFileCreator("execute-simprog-local");
        } else {
            hookFileCreator = new HookFileCreator("execute-simprog-remote");
            hookFileCreator.addStringReplacement("REMOTE_HOSTNAME", this.slot.hostName());
        }
        hookFileCreator.addStringReplacement("COMMAND", origCommand);
        CommandOutputHandler stdoutHandler = this.isSimTreeParent ? new CommandOutputHandler(false, false, null, true) : new CommandOutputHandler(false, true, null, true);
        CommandOutputHandler stderrHandler = new CommandOutputHandler(true, false, null, false);
        int exitValue = -1;
        CommandRunner commandRunner = new CommandRunner(this.workingDirName, this.sc);
        commandRunner.setWorkDesc(this.workItem.workDesc);
        commandRunner.enableHandleProcessList();
        if (!this.isSimTreeParent) {
            commandRunner.enablePassThroughStdin();
        }
        try {
            exitValue = hookFileCreator.createAndExecute((CommandRunner)commandRunner, (CommandOutputHandler)stdoutHandler, (CommandOutputHandler)stderrHandler).exitValue;
        }
        catch (SimTreeException e) {
            Message.error("Cannot create subprocess: " + e.getMessage(), this.sc);
        }
        if (exitValue != 0) {
            Helpers.printFailedProgramOutputStdErr(exitValue, stderrHandler, "The failed command was [" + origCommand + "] started on " + (this.slot.isLocal() ? "the local host" : this.slot.hostName()), this.sc);
        }
        Helpers.setExitValue(exitValue);
        if (!this.slot.isLocal() && exitValue == 255) {
            Message.warning("Calling the remote command failed, removing the failing slot on host " + this.slot.hostName(), this.sc);
            this.slot.removeMe();
        }
        this.slot.free();
        this.workItem.addInfo(new StringWorkItemInfo("(" + exitValue + ")", true));
        this.workItem.addInfo(new StringsWorkItemInfo("Messages from simtree-callsim and from the simulation binary", stdoutHandler.getUpstreamMessageCollector().getChannelMessages(ChannelEnum.CS, ChannelCommandEnum.NONE)));
        this.workItem.fromRunningToFinished();
        ConditionNotifyCreator.createAndExecute("st.b.notify_simulation_condition.1", ConditionEnum.SIMULATION_FINISHED, this.workingDirName, new StringPair[]{new StringPair("SIMPARA_PATH_STRING", this.simParaPath.toFormattedString()), new StringPair("STATUS", "return code " + exitValue), new StringPair("COMMAND", this.command)}, this.sc);
        Helpers.atThreadExit();
    }

    public static boolean areSimThreadsRunning() {
        return SimThread.areSimThreadsRunningR(Thread.currentThread().getThreadGroup());
    }

    private static boolean areSimThreadsRunningR(ThreadGroup group) {
        int numThreads = group.activeCount();
        Thread[] threads = new Thread[numThreads * 2];
        numThreads = group.enumerate(threads, false);
        int i = 0;
        while (i < numThreads) {
            if (threads[i].getName().startsWith(SIMTHREAD_NAME_START)) {
                return true;
            }
            ++i;
        }
        int numGroups = group.activeGroupCount();
        ThreadGroup[] groups = new ThreadGroup[numGroups * 2];
        numGroups = group.enumerate(groups, false);
        int i2 = 0;
        while (i2 < numGroups) {
            if (SimThread.areSimThreadsRunningR(groups[i2])) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    protected static String createUniqueName(Thread thread) {
        return "SimTreeSimThread-" + thread.getId();
    }
}

