/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.runsim;

import ikr.simtree.base.Message;
import ikr.simtree.base.Strings;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.runsim.ProcessSlot;
import java.util.ArrayList;

public class ProcessSlots {
    private final ArrayList<ProcessSlot> slots = new ArrayList(30);
    private int useCount = 0;
    private int freeCount = 0;

    protected synchronized void incUseCount() {
        ++this.useCount;
    }

    protected synchronized void incFreeCount() {
        ++this.freeCount;
    }

    public synchronized void add(ProcessSlot slot) {
        this.slots.add(slot);
    }

    public synchronized int size() {
        return this.slots.size();
    }

    protected synchronized boolean isFree(int i) {
        return this.slots.get(i).isFree();
    }

    protected synchronized ProcessSlot getSlot(int i) {
        return this.slots.get(i);
    }

    protected synchronized boolean areAllFree() {
        int i = 0;
        while (i < this.size()) {
            if (!this.slots.get(i).isFree()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected synchronized void printStatus(SimTreeContext sc) {
        int running = this.useCount - this.freeCount;
        Message.notice("Completed " + String.format("%2d", new Integer(this.freeCount)) + " processes" + (running == 0 ? "" : ", Running " + String.format("%2d", new Integer(running)) + " processes"), sc);
    }

    protected synchronized Strings getSlotStatusStrings() {
        Strings ret = new Strings();
        for (ProcessSlot s : this.slots) {
            ret.addAll(s.getStatusString());
        }
        return ret;
    }

    protected synchronized int removeLocalSlot() {
        ProcessSlot toRemove = null;
        for (ProcessSlot slot : this.slots) {
            if (!slot.isLocal()) continue;
            toRemove = slot;
            break;
        }
        if (toRemove != null) {
            this.slots.remove(toRemove);
            return 1;
        }
        return 0;
    }

    protected synchronized int removeRemoteSlot(String hostName) {
        ProcessSlot toRemove = null;
        for (ProcessSlot slot : this.slots) {
            if (slot.isLocal() || !slot.hostName().equalsIgnoreCase(hostName)) continue;
            toRemove = slot;
            break;
        }
        if (toRemove != null) {
            this.slots.remove(toRemove);
            return 1;
        }
        return 0;
    }

    protected synchronized void removeSlot(ProcessSlot slot) {
        this.slots.remove(slot);
    }
}

