/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.runsim;

import ikr.simtree.base.SHelpers;
import ikr.simtree.base.Strings;
import ikr.simtree.runsim.ProcessSlots;
import ikr.simtree.workingset.WorkDesc;

public class ProcessSlot {
    private final ProcessSlots slots;
    private final String hostName;
    private boolean isFree = true;
    private WorkDesc workDesc;

    protected ProcessSlot(String hostName, ProcessSlots slots) {
        assert (hostName != null);
        this.hostName = hostName;
        this.slots = slots;
    }

    protected ProcessSlot(ProcessSlots slots) {
        this.slots = slots;
        this.hostName = null;
    }

    protected synchronized boolean isLocal() {
        return this.hostName == null;
    }

    protected synchronized String hostName() {
        return this.hostName;
    }

    protected synchronized void use(WorkDesc wd) {
        assert (Thread.currentThread().getName().equals("main"));
        assert (this.isFree);
        this.isFree = false;
        this.slots.incUseCount();
        this.workDesc = wd;
    }

    protected synchronized void free() {
        assert (!this.isFree);
        this.isFree = true;
        this.slots.incFreeCount();
        this.workDesc = null;
    }

    protected synchronized boolean isFree() {
        return this.isFree;
    }

    protected synchronized Strings getStatusString() {
        Strings ret = new Strings();
        if (this.isLocal()) {
            ret.add("Local Slot");
        } else {
            ret.add("Remote slot on " + this.hostName);
        }
        if (this.workDesc != null) {
            ret.add(String.valueOf(SHelpers.indent(1)) + this.workDesc.toFormattedString());
        } else {
            ret.add(String.valueOf(SHelpers.indent(1)) + "(Not used)");
        }
        return ret;
    }

    protected synchronized void removeMe() {
        this.slots.removeSlot(this);
    }
}

