/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.query;

import ikr.simtree.base.SimTreeException;
import ikr.simtree.eval.ParseResultsList;
import ikr.simtree.query.ParserQueryHandler;
import ikr.simtree.resultdef.SingleRunResultDef;
import java.util.ArrayList;

public class ParserQueryHandlers {
    private final ArrayList<ParserQueryHandler> handlers = new ArrayList();
    private boolean resultsAreInvalid = false;

    public void addQuery(ParserQueryHandler parserQueryHandler) {
        this.handlers.add(parserQueryHandler);
    }

    public void addResultDep(int thisLevel, String stringFromXMLFile, String name, String value, String type) throws SimTreeException {
        int i = 0;
        while (i < this.handlers.size()) {
            this.handlers.get(i).addResultDep(thisLevel, stringFromXMLFile, name, value, type);
            ++i;
        }
    }

    public void addResultDep(int thisLevel, String stringFromXMLFile, String name, String value) throws SimTreeException {
        int i = 0;
        while (i < this.handlers.size()) {
            this.handlers.get(i).addResultDep(thisLevel, stringFromXMLFile, name, value);
            ++i;
        }
    }

    public void resetMatch(int level) {
        int i = 0;
        while (i < this.handlers.size()) {
            this.handlers.get(i).resetMatch(level);
            ++i;
        }
    }

    public void parseIsComplete() {
        for (ParserQueryHandler query : this.handlers) {
            query.parseIsComplete();
        }
    }

    public void setResultsAreInvalid() {
        this.resultsAreInvalid = true;
    }

    public void setResultDef(SingleRunResultDef singleRunResultDef) {
        for (ParserQueryHandler query : this.handlers) {
            query.setResultDef(singleRunResultDef);
        }
    }

    public ParseResultsList getResults() {
        ParseResultsList parseResultsList = new ParseResultsList();
        if (!this.resultsAreInvalid) {
            for (ParserQueryHandler query : this.handlers) {
                assert (query.parseResults != null);
                parseResultsList.add(query.parseResults);
            }
        }
        return parseResultsList;
    }
}

