/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.query;

import ikr.simtree.base.Message;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.graphwriter.PrintServerPath;
import ikr.simtree.gui.TabTypeEnum;
import ikr.simtree.gui.tree.ValueInTreeForDump;
import ikr.simtree.gui.tree.ValueTree;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.query.ParserHandlerConfig;
import ikr.simtree.query.ParserQueryHandler;

public class ParserDumpHandler
extends ParserQueryHandler {
    private final String indent;
    private final int maxDepth;
    private final boolean visual;
    private final String header;
    private final SimTreeContext sc;
    private int lastDepth = 1;
    private PrintServerPath lastPath;
    private ValueTree valueTree;

    public ParserDumpHandler(String header, boolean visual, PrintServerPath searchPath, String indent, int maxDepth, SimTreeContext sc) throws SimTreeException {
        super(searchPath, null, new ParserHandlerConfig(true, false));
        this.indent = indent;
        this.maxDepth = maxDepth;
        this.visual = visual;
        this.sc = sc;
        assert (header != null);
        this.header = header;
        if (visual) {
            this.valueTree = new ValueTree(new ValueInTreeForDump(header, sc), sc);
        } else {
            Message.notice(header, sc);
        }
    }

    @Override
    protected void addResult(String name, String value) throws SimTreeException {
        if (this.maxDepth != -1) {
            assert (!this.visual);
            PrintServerPath p = this.getMatchPathClone();
            if (p.size() <= this.maxDepth) {
                if (this.visual) {
                    this.addValueToTree(p, (String)p.get(p.size() - 1));
                } else {
                    Message.resultOut(p.toComposedString(), this.indent);
                }
            }
        }
    }

    @Override
    protected void addResult(String name, String value, String type) throws SimTreeException {
        PrintServerPath p = this.getMatchPathClone();
        if (this.maxDepth == -1 || p.size() <= this.maxDepth) {
            String s = " = " + value + " (" + type + ")";
            if (this.visual) {
                this.addValueToTree(p, String.valueOf((String)p.get(p.size() - 1)) + s);
            } else {
                Message.resultOut(String.valueOf(p.toComposedString()) + s, this.indent);
            }
        }
    }

    private void addValueToTree(PrintServerPath p, String content) throws SimTreeException {
        int i;
        assert (this.lastDepth >= 1);
        assert (this.visual);
        if (this.lastPath != null) {
            i = 0;
            while (i < p.size() - 1) {
                if (!((String)this.lastPath.get(i)).equals(p.get(i))) {
                    this.lastDepth = i + 1;
                    break;
                }
                ++i;
            }
        }
        i = this.lastDepth;
        while (i < p.size()) {
            this.valueTree.addEntry(new ValueInTreeForDump(((String)p.get(i - 1)).toString(), this.sc), i);
            ++i;
        }
        this.valueTree.addEntry(new ValueInTreeForDump(content, this.sc), p.size());
        this.lastDepth = p.size();
        this.lastPath = p;
    }

    @Override
    protected void parseIsComplete() {
        if (this.visual) {
            this.valueTree.createView(TabTypeEnum.DUMP_TREE, this.header, false);
        }
    }
}

