/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.parser;

import ikr.simtree.base.Message;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.eval.EvalResult;
import ikr.simtree.eval.ResultFile;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.parser.BZIP2FileSource;
import ikr.simtree.parser.FileSource;
import ikr.simtree.parser.GZIPFileSource;
import ikr.simtree.parser.LZMAFileSource;
import ikr.simtree.parser.ParserTask;
import ikr.simtree.parser.ResultFileParser;
import ikr.simtree.parser.UnpackeFileSource;
import ikr.simtree.vfs.results.node.ResultFileName;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ResultFilesParser
implements Runnable {
    private final LinkedBlockingQueue<ParserTask> parserTaskQueue;
    private final CountDownLatch countDownLatch;
    private final SimTreeContext sc;

    public ResultFilesParser(LinkedBlockingQueue<ParserTask> parserTaskQueue, CountDownLatch countDownLatch, SimTreeContext sc) {
        this.parserTaskQueue = parserTaskQueue;
        this.countDownLatch = countDownLatch;
        this.sc = sc;
    }

    public static void parseResultFile(File file, DefaultHandler docHandler) throws SimTreeException {
        String fPath = file.getPath();
        ResultFileName resultFileName = new ResultFileName(fPath);
        InputSource source = null;
        FileInputStream fstream = null;
        try {
            fstream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new SimTreeException("Invalid or non-existing result path " + fPath + " (" + e.getMessage() + ")");
        }
        FileSource fileSource = null;
        try {
            if (resultFileName.isGZPacked()) {
                fileSource = new GZIPFileSource();
            } else if (resultFileName.isLBZ2Packed()) {
                fileSource = new BZIP2FileSource();
            } else if (resultFileName.isLZMAPacked()) {
                fileSource = new LZMAFileSource();
            } else if (resultFileName.isUnPacked()) {
                fileSource = new UnpackeFileSource();
            } else {
                throw new SimTreeException("Invalid file extension, cannot parse file " + fPath);
            }
            assert (fileSource != null);
            source = fileSource.getSource(fstream);
        }
        catch (IOException e) {
            throw new SimTreeException("Parse error while parsing " + fPath + " (" + e.getMessage() + ")");
        }
        if (source == null) {
            throw new SimTreeException("Cannot handle file " + fPath);
        }
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(source, docHandler);
        }
        catch (IOException e) {
            throw new SimTreeException("IO error while parsing " + fPath);
        }
        catch (ParserConfigurationException e) {
            throw new SimTreeException("Parser configuration error " + e.getMessage());
        }
        catch (SAXException e) {
            throw new SimTreeException("SAX exception " + e.getMessage());
        }
        try {
            assert (fstream != null);
            fstream.close();
            assert (fileSource != null);
            fileSource.closeInputStream();
        }
        catch (IOException e) {
            throw new SimTreeException("Error closing stream");
        }
    }

    @Override
    public void run() {
        ParserTask task = null;
        try {
            while (true) {
                try {
                    task = this.parserTaskQueue.take();
                }
                catch (InterruptedException e) {
                    continue;
                }
                if (task.resultFiles == null) {
                    this.countDownLatch.countDown();
                    return;
                }
                for (ResultFile resultFile : task.resultFiles) {
                    ResultFilesParser.parseResultFile(resultFile.file, new ResultFileParser(resultFile, task.parserQueryHandlers, this.sc));
                }
                task.evalResults.addResult(new EvalResult(task.simParaPath, task.parserQueryHandlers.getResults()));
            }
        }
        catch (SimTreeException e) {
            Message.fatal(e.getMessage(), this.sc);
            return;
        }
    }
}

