/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.parser;

import ikr.simtree.base.Message;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.eval.ResultFile;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.query.ParserQueryHandler;
import ikr.simtree.query.ParserQueryHandlers;
import ikr.simtree.vfs.StudyRootVFS;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ResultFileParser
extends DefaultHandler {
    private int level;
    private final ParserQueryHandlers parserQueryHandlers;
    private final String currentFileName;
    private int fileVersion = -1;
    private final SimTreeContext sc;

    protected ResultFileParser(ResultFile resultFile, ParserQueryHandlers parserQueryHandlers, SimTreeContext sc) {
        this.currentFileName = resultFile.getName();
        this.sc = sc;
        this.parserQueryHandlers = parserQueryHandlers;
        parserQueryHandlers.setResultDef(resultFile.singleRunResultDef);
        if (sc.isVerbose()) {
            Message.notice("Parsing " + StudyRootVFS.reduceName(this.currentFileName), sc);
        }
    }

    public ResultFileParser(ResultFile resultFile, ParserQueryHandler parserQueryHandler, SimTreeContext sc) {
        this.currentFileName = resultFile.getName();
        this.sc = sc;
        ParserQueryHandlers handlers = new ParserQueryHandlers();
        handlers.addQuery(parserQueryHandler);
        this.parserQueryHandlers = handlers;
        this.parserQueryHandlers.setResultDef(resultFile.singleRunResultDef);
        if (sc.isVerbose()) {
            Message.notice("Parsing " + StudyRootVFS.reduceName(this.currentFileName), sc);
        }
    }

    private void handleFatalError(String msg) throws SimTreeException {
        throw new SimTreeException("Fatal error while parsing " + this.currentFileName + ": " + msg);
    }

    private void handleParserWarning(String msg) {
        Message.warning("Parse error in " + this.currentFileName + ": " + msg + " (results deleted)", this.sc);
        this.parserQueryHandlers.setResultsAreInvalid();
    }

    private void handleUnknownTagError(String tag) throws SimTreeException {
        this.handleFatalError("Unknown tag " + tag);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            String attrName = null;
            String attrType = null;
            String attrValue = null;
            String attrIndex = null;
            int i = 0;
            while (i < attributes.getLength()) {
                String qname = attributes.getQName(i);
                String attr = attributes.getValue(i).trim();
                if (qname.equals("name")) {
                    attrName = attr;
                } else if (qname.equals("type")) {
                    attrType = attr;
                } else if (qname.equals("value")) {
                    attrValue = attr;
                } else if (qname.equals("index")) {
                    attrIndex = attr;
                }
                ++i;
            }
            if (this.fileVersion == 1) {
                if (qName.equals("ResultNode")) {
                    if (attrType != null) {
                        if (attrIndex != null) {
                            this.parserQueryHandlers.addResultDep(this.level, attrIndex, "index", attrIndex);
                        } else {
                            this.parserQueryHandlers.addResultDep(this.level, attrName, attrType, attrName);
                        }
                    } else {
                        this.handleParserWarning("Missing type attribute");
                    }
                } else if (qName.equals("Result")) {
                    if (attrValue != null) {
                        this.parserQueryHandlers.addResultDep(this.level, attrName, attrName, attrValue, attrType);
                    } else {
                        this.parserQueryHandlers.addResultDep(this.level, attrName, "Array", attrName);
                    }
                } else {
                    this.handleUnknownTagError(qName);
                }
            } else if (this.fileVersion == 2) {
                if (qName.equals("Node")) {
                    this.parserQueryHandlers.addResultDep(this.level, attrName, attrType, attrName);
                } else if (qName.equals("Result")) {
                    this.parserQueryHandlers.addResultDep(this.level, attrName, attrName, attrValue, attrType);
                } else if (qName.equals("Array")) {
                    this.parserQueryHandlers.addResultDep(this.level, attrName, "Array", attrName);
                } else if (qName.equals("ArrayItem")) {
                    this.parserQueryHandlers.addResultDep(this.level, attrIndex, "ArrayIndex", attrIndex);
                } else {
                    this.handleUnknownTagError(qName);
                }
            } else if (qName.equals("SimulationResults")) {
                if (this.level != -1) {
                    this.handleFatalError("Tag SimulationResults is not on top level");
                }
                if (this.fileVersion != -1) {
                    this.handleFatalError("Invalid file structure");
                }
                String attVersion = null;
                int i2 = 0;
                while (i2 < attributes.getLength()) {
                    if (attributes.getQName(i2).equals("version")) {
                        attVersion = attributes.getValue(i2).trim();
                        break;
                    }
                    ++i2;
                }
                if (attVersion == null || !attVersion.equals("1") && !attVersion.equals("2")) {
                    this.handleFatalError("Wrong XML File version " + attVersion);
                }
                this.fileVersion = new Integer(attVersion);
            } else {
                this.handleUnknownTagError(qName);
            }
            ++this.level;
        }
        catch (SimTreeException e) {
            Message.fatal(e.getMessage(), this.sc);
        }
    }

    @Override
    public final void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.level < 0) {
            this.handleParserWarning("Structure error, reaching negative level");
        }
        --this.level;
        if (this.level >= 0) {
            this.parserQueryHandlers.resetMatch(this.level);
        }
    }

    @Override
    public final void startDocument() throws SAXException {
        this.level = -1;
    }

    @Override
    public final void endDocument() throws SAXException {
        if (this.level != -1) {
            this.handleParserWarning("End of Document reached but current depth != 0");
        }
        this.parserQueryHandlers.parseIsComplete();
    }

    @Override
    public final void warning(SAXParseException e) throws SAXException {
        this.handleParserWarning("XML Parser warning: " + e.getMessage());
    }

    @Override
    public final void error(SAXParseException e) throws SAXException {
        this.handleParserWarning("XML Parser error: " + e.getMessage());
    }

    @Override
    public final void fatalError(SAXParseException e) throws SAXException {
        this.handleParserWarning("XML Parser fatal error: " + e.getMessage());
    }
}

