/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.parser;

import ikr.simtree.base.SimTreeException;
import ikr.simtree.eval.EvalResults;
import ikr.simtree.eval.ResultFile;
import ikr.simtree.eval.ResultFiles;
import ikr.simtree.graphwriter.PrintServerPath;
import ikr.simtree.query.ParserHandlerConfig;
import ikr.simtree.query.ParserQueryHandler;
import ikr.simtree.query.ParserQueryHandlers;
import ikr.simtree.simpara.SimParaPath;
import java.io.File;

public class ParserTask {
    protected final ResultFiles resultFiles;
    protected final SimParaPath simParaPath;
    protected final EvalResults evalResults;
    protected final ParserQueryHandlers parserQueryHandlers;
    private final ParserHandlerConfig parserHandlerConfig;

    public ParserTask(ResultFiles resultFiles, SimParaPath simParaPath, EvalResults evalResults, ParserHandlerConfig parserHandlerConfig) {
        assert (resultFiles != null);
        assert (resultFiles.size() != 0);
        this.resultFiles = resultFiles;
        this.simParaPath = simParaPath;
        this.evalResults = evalResults;
        this.parserQueryHandlers = new ParserQueryHandlers();
        this.parserHandlerConfig = parserHandlerConfig;
    }

    public ParserTask(File resultFile, SimParaPath simParaPath, EvalResults evalResults, ParserHandlerConfig parserHandlerConfig) {
        this(new ResultFiles(new ResultFile(resultFile)), simParaPath, evalResults, parserHandlerConfig);
    }

    public ParserTask() {
        this.resultFiles = null;
        this.evalResults = null;
        this.simParaPath = null;
        this.parserQueryHandlers = null;
        this.parserHandlerConfig = new ParserHandlerConfig(false, false);
    }

    public void addQuery(PrintServerPath searchPath, String searchName) throws SimTreeException {
        this.parserQueryHandlers.addQuery(new ParserQueryHandler(searchPath, searchName, this.parserHandlerConfig));
    }
}

