/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.options;

import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.SimTreeOptionException;
import ikr.simtree.commands.CommandEnum;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.Option;
import ikr.simtree.options.OptionEnum;
import ikr.simtree.options.OptionSourceEnum;
import ikr.simtree.options.Options;
import ikr.simtree.options.SimulationParameterOption;
import ikr.simtree.options.SingleArgOption;
import ikr.simtree.simpara.SimPara;
import ikr.simtree.simpara.SimParaOptions;
import ikr.simtree.simpara.SimParaPath;

public class SimulationParameterPathOption
extends SingleArgOption {
    public SimulationParameterPathOption(OptionEnum optionEnum, OptionSourceEnum source, SimTreeContext sc) {
        super(optionEnum, source, sc);
    }

    @Override
    protected void checkDependencies(Options options, CommandEnum commandEnum) throws SimTreeException {
        this.checkOnlyOnce(options);
        boolean foundUs = false;
        for (Option opt : options) {
            if (opt.getOptionEnum() == OptionEnum.SIMULATION_PARAMETER && !foundUs) {
                throw new SimTreeOptionException(this.getOptionEnum(), "No" + OptionEnum.SIMULATION_PARAMETER.hlp11 + "options are allowed before this option");
            }
            if (opt != this) continue;
            foundUs = true;
        }
    }

    public SimParaOptions getSimParaOptionList(SimParaPath currentResultTreeSimParaPath) throws SimTreeException {
        String[] pathElements = this.getSingleArg().split(":");
        SimParaOptions ret = new SimParaOptions();
        if (currentResultTreeSimParaPath.size() < pathElements.length) {
            throw new SimTreeException("Invalid simulation parameter path option, must not have more elements than simulation parameters in the current reesults tree");
        }
        int i = 0;
        while (i < pathElements.length) {
            SimPara treePara = (SimPara)currentResultTreeSimParaPath.get(i);
            ret.add(new SimulationParameterOption(treePara.getParaName(), treePara.getParaType(), pathElements[i], this.getSource(), this.sc));
            ++i;
        }
        return ret;
    }
}

