/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.options;

import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.SimTreeOptionException;
import ikr.simtree.base.Strings;
import ikr.simtree.commands.CommandEnum;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.Option;
import ikr.simtree.options.OptionEnum;
import ikr.simtree.options.OptionSourceEnum;
import ikr.simtree.options.Options;
import ikr.simtree.simpara.SimParaHelpers;
import ikr.simtree.simpara.SimParaTypeEnum;
import ikr.simtree.simpara.ValuePatterns;

public class SimulationParameterOption
extends Option {
    private String paraName;
    private SimParaTypeEnum paraType;
    private ValuePatterns valuesPatterns;

    public SimulationParameterOption(OptionEnum optionEnum, OptionSourceEnum source, SimTreeContext sc) {
        super(optionEnum, source, sc);
    }

    protected SimulationParameterOption(String paraName, SimParaTypeEnum paraType, String value, OptionSourceEnum source, SimTreeContext sc) throws SimTreeException {
        this(OptionEnum.SIMULATION_PARAMETER, source, sc);
        assert (paraName != null && paraName.length() != 0);
        this.paraName = paraName;
        this.paraType = paraType;
        this.valuesPatterns = value != null && value.length() != 0 ? new ValuePatterns(value, false, paraType) : new ValuePatterns();
    }

    public SimulationParameterOption(String paraName, SimParaTypeEnum paraType, ValuePatterns simParaValues, SimTreeContext sc) throws SimTreeException {
        this(OptionEnum.SIMULATION_PARAMETER, OptionSourceEnum.GENERATED_DEFAULT, sc);
        this.paraName = paraName;
        this.paraType = paraType;
        this.valuesPatterns = simParaValues;
        assert (simParaValues != null);
        assert (paraName != null);
    }

    @Override
    protected void checkDependencies(Options options, CommandEnum commandEnum) throws SimTreeException {
        this.conflictWhenFirstArgEqual(options);
    }

    @Override
    protected void parseArguments(Strings arguments) throws SimTreeException {
        int numArgs = arguments.size();
        int currentArg = 0;
        if (numArgs < 1) {
            throw new SimTreeOptionException(this.getOptionEnum(), "At least one argument required");
        }
        this.paraName = (String)arguments.get(0);
        if (!SimParaHelpers.isSimParaNameValid(this.paraName)) {
            throw new SimTreeOptionException(this.getOptionEnum(), "Parameter name " + this.paraName + " is invalid");
        }
        if (++currentArg >= numArgs) {
            this.valuesPatterns = new ValuePatterns();
            return;
        }
        String typeStr = (String)arguments.get(currentArg);
        this.paraType = null;
        SimParaTypeEnum[] simParaTypeEnumArray = SimParaTypeEnum.values();
        int n = simParaTypeEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            SimParaTypeEnum type = simParaTypeEnumArray[n2];
            if (typeStr.equals(type.typeName)) {
                this.paraType = type;
            }
            ++n2;
        }
        if (this.paraType != null) {
            ++currentArg;
        }
        this.valuesPatterns = new ValuePatterns(arguments, currentArg, this.paraType);
    }

    public void setType(SimParaTypeEnum type) throws SimTreeException {
        assert (this.paraType == null);
        this.paraType = type;
        assert (this.valuesPatterns != null);
        assert (type != null);
        this.valuesPatterns.checkValueTypes(this.paraType);
    }

    public String getParaName() {
        assert (SimParaHelpers.isSimParaNameValid(this.paraName));
        return this.paraName;
    }

    public SimParaTypeEnum getParaType() {
        return this.paraType;
    }

    public ValuePatterns getValuePatterns() {
        assert (this.valuesPatterns != null);
        return this.valuesPatterns;
    }
}

