/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.options;

import ikr.simtree.base.Helpers;
import ikr.simtree.base.Message;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.SimTreeOptionException;
import ikr.simtree.base.Strings;
import ikr.simtree.commands.CommandEnum;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.Option;
import ikr.simtree.options.OptionEnum;
import ikr.simtree.options.OptionSourceEnum;
import ikr.simtree.options.Options;
import ikr.simtree.vfs.StudyRootVFS;
import java.io.File;

public class SaveConfigOption
extends Option {
    private String configName = null;

    public SaveConfigOption(OptionEnum optionEnum, OptionSourceEnum source, SimTreeContext sc) {
        super(optionEnum, source, sc);
    }

    @Override
    protected void checkDependencies(Options options, CommandEnum commandEnum) {
    }

    @Override
    protected void parseArguments(Strings arguments) throws SimTreeException {
        if (arguments.size() > 1) {
            throw new SimTreeOptionException(this.getOptionEnum(), "Only one argument allowed");
        }
        if (arguments.size() == 1) {
            this.configName = (String)arguments.get(0);
        }
    }

    @Override
    protected void finalizeInit(Options optionList) throws SimTreeException {
        boolean saveInCustomFile;
        String fname;
        String cname;
        super.finalizeInit(optionList);
        if (this.configName == null) {
            cname = "(Default)";
            fname = StudyRootVFS.getDefaultConfigFileName();
            saveInCustomFile = false;
        } else {
            cname = this.configName;
            fname = StudyRootVFS.getCustomConfigFileName(cname);
            saveInCustomFile = true;
        }
        Options saveOptions = new Options(this.sc);
        for (Option option : optionList) {
            if (option.getSaveCondition() == Option.SaveConditionEnum.ALWAYS && option.getSource() == OptionSourceEnum.GENERATED_DEFAULT || option.getSaveCondition() == Option.SaveConditionEnum.WHEN_FROM_COMMANDLINE_ONLY && option.getSource() != OptionSourceEnum.COMMAND_LINE) continue;
            switch (option.getSaveTarget()) {
                case NA: {
                    break;
                }
                case GLOBAL_CONFIG_FILE_ONLY: {
                    if (saveInCustomFile) break;
                    saveOptions.add(option);
                    break;
                }
                case CUSTOM_CONFIG_FILE_ONLY: {
                    if (!saveInCustomFile) break;
                    saveOptions.add(option);
                    break;
                }
                case ANY_CONFIG_FILE: {
                    saveOptions.add(option);
                }
            }
        }
        File file = new File(fname);
        if (!file.exists() && this.getOptionEnum() == OptionEnum.REPLACE_CONFIG) {
            throw new SimTreeOptionException(this.getOptionEnum(), "configuration " + cname + " does not exist, please use the " + OptionEnum.SAVE_CONFIG.longNameWithStarter + " to overwrite");
        }
        if (file.exists() && this.getOptionEnum() != OptionEnum.REPLACE_CONFIG) {
            throw new SimTreeOptionException(this.getOptionEnum(), "configuration " + cname + " exists, please use the " + OptionEnum.REPLACE_CONFIG.longNameWithStarter + " to overwrite");
        }
        if (!file.exists() || this.getOptionEnum() == OptionEnum.REPLACE_CONFIG) {
            Message.notice("Writing config file " + StudyRootVFS.reduceName(fname), this.sc);
            Helpers.writeConfigFile(fname, saveOptions, "SimTree options written by SimTree");
        }
    }
}

