/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.options;

import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.Strings;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.BatchesOption;
import ikr.simtree.options.BoolOption;
import ikr.simtree.options.ColumnDefinitionOption;
import ikr.simtree.options.ControlCommandOption;
import ikr.simtree.options.DropsOption;
import ikr.simtree.options.GraphWriterOption;
import ikr.simtree.options.LoadConfigOption;
import ikr.simtree.options.LocalProcessSlotsOption;
import ikr.simtree.options.MaxDepthOption;
import ikr.simtree.options.Option;
import ikr.simtree.options.OptionEnum;
import ikr.simtree.options.OptionSourceEnum;
import ikr.simtree.options.PrintFormatOption;
import ikr.simtree.options.RemoteProcessSlotsOption;
import ikr.simtree.options.ResultPathOption;
import ikr.simtree.options.SaveConfigOption;
import ikr.simtree.options.SimulationParameterOption;
import ikr.simtree.options.SimulationParameterPathOption;
import ikr.simtree.options.SingleArgOption;

public abstract class OptionFactory {
    public static Option create(String givenName, Strings arguments, OptionSourceEnum source, SimTreeContext sc) throws SimTreeException {
        assert (givenName != null && givenName.length() != 0);
        OptionEnum optionEnum = OptionEnum.getOptionEnumFromName(givenName);
        if (optionEnum == null) {
            throw new SimTreeException("Invalid option " + givenName);
        }
        Option o = null;
        switch (optionEnum) {
            case VERBOSE: {
                if (source == OptionSourceEnum.GENERATED_DEFAULT) break;
                sc.setIsVerbose();
                break;
            }
            case VERY_VERBOSE: {
                if (source == OptionSourceEnum.GENERATED_DEFAULT) break;
                sc.setIsVeryVerbose();
                break;
            }
            case HELP: 
            case IGNORE_DEFAULT_CONFIG: 
            case FORCE_ALL_VALUES: 
            case FORCE_DELETE_FOREIGN_FILES: 
            case CHILD: {
                o = new BoolOption(optionEnum, source, sc);
                break;
            }
            case STUDY_ROOT: 
            case SIMULATION_BINARY: 
            case PARAMETER_FILE_TEMPLATE: 
            case FILTER_FILE: 
            case WORKING_DIRECTORY: 
            case RESULT_FILE_NAME: {
                o = new SingleArgOption(optionEnum, source, sc);
                break;
            }
            case BATCHES: {
                o = new BatchesOption(optionEnum, source, sc);
                break;
            }
            case DROPS: {
                o = new DropsOption(optionEnum, source, sc);
                break;
            }
            case COLUMN_DEFINITION: {
                o = new ColumnDefinitionOption(optionEnum, source, sc);
                break;
            }
            case GRAPH_WRITER: {
                o = new GraphWriterOption(optionEnum, source, sc);
                break;
            }
            case LOAD_CONFIG: {
                o = new LoadConfigOption(optionEnum, source, sc);
                break;
            }
            case LOCAL_PROCESS_SLOTS: {
                o = new LocalProcessSlotsOption(optionEnum, source, sc);
                break;
            }
            case MAX_DEPTH: {
                o = new MaxDepthOption(optionEnum, source, sc);
                break;
            }
            case PRINT_FORMAT: {
                o = new PrintFormatOption(optionEnum, source, sc);
                break;
            }
            case REMOTE_PROCESS_SLOTS: {
                o = new RemoteProcessSlotsOption(optionEnum, source, sc);
                break;
            }
            case REPLACE_CONFIG: {
                o = new SaveConfigOption(optionEnum, source, sc);
                break;
            }
            case RESULT_PATH: {
                o = new ResultPathOption(optionEnum, source, sc);
                break;
            }
            case SAVE_CONFIG: {
                o = new SaveConfigOption(optionEnum, source, sc);
                break;
            }
            case SIMULATION_PARAMETER: {
                o = new SimulationParameterOption(optionEnum, source, sc);
                break;
            }
            case SIMULATION_PARAMETER_PATH: {
                o = new SimulationParameterPathOption(optionEnum, source, sc);
                break;
            }
            case CONTROL_COMMAND: {
                o = new ControlCommandOption(optionEnum, source, sc);
            }
        }
        if (o != null && arguments != null) {
            o.setAndParseArguments(arguments);
        }
        return o;
    }
}

