/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.options;

import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.SimTreeOptionException;
import ikr.simtree.base.StringPair;
import ikr.simtree.base.Strings;
import ikr.simtree.commands.CommandEnum;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.OptionEnum;
import ikr.simtree.options.OptionSourceEnum;
import ikr.simtree.options.Options;

public abstract class Option {
    public final OptionEnum optionEnum;
    private Strings arguments;
    private final OptionSourceEnum source;
    protected final SimTreeContext sc;

    protected Option(OptionEnum optionEnum, OptionSourceEnum source, SimTreeContext sc) {
        this.optionEnum = optionEnum;
        this.source = source;
        this.sc = sc;
    }

    protected void setAndParseArguments(Strings arguments) throws SimTreeException {
        assert (arguments != null);
        this.arguments = arguments;
        this.parseArguments(arguments);
    }

    protected OptionSourceEnum getSource() {
        assert (this.source != null);
        return this.source;
    }

    protected MergeModeEnum getMergeMode() {
        return this.optionEnum.mergeMode;
    }

    protected OptionEnum getOptionEnum() {
        return this.optionEnum;
    }

    protected SaveTargetEnum getSaveTarget() {
        return this.optionEnum.saveTarget;
    }

    protected SaveConditionEnum getSaveCondition() {
        return this.optionEnum.saveCondition;
    }

    protected void replaceArgument(int index, String arg) {
        this.arguments.set(index, arg);
    }

    protected Option createDefault() throws SimTreeException {
        return null;
    }

    protected abstract void parseArguments(Strings var1) throws SimTreeException;

    protected boolean modifyOptions(Options optionList, CommandEnum commandEnum) throws SimTreeException {
        return false;
    }

    protected abstract void checkDependencies(Options var1, CommandEnum var2) throws SimTreeException;

    protected void finalizeInit(Options optionList) throws SimTreeException {
    }

    protected void finalMessage() {
    }

    protected void conflictWhenFirstArgEqual(Options optionList) throws SimTreeException {
        for (Option option : optionList) {
            if (option.optionEnum != this.optionEnum || option == this || !((String)this.arguments.get(0)).equals(option.arguments.get(0))) continue;
            throw new SimTreeOptionException(this.optionEnum, "More than one option with the given argument " + (String)this.arguments.get(0));
        }
    }

    protected void checkOnlyOnce(Options optionList) throws SimTreeException {
        if (optionList.getOptions(this.optionEnum).size() > 1) {
            throw new SimTreeOptionException(this.optionEnum, "Option must not given more than once");
        }
    }

    protected void conflictsWith(Options optionList, OptionEnum otherOption) throws SimTreeException {
        if (optionList.getOptions(otherOption).size() != 0) {
            throw new SimTreeOptionException(this.optionEnum, "Option conflicts with given option " + otherOption.longNameWithStarter);
        }
    }

    protected void requiresOption(Options optionList, OptionEnum otherOption) throws SimTreeException {
        if (optionList.getOptions(otherOption).size() == 0) {
            throw new SimTreeOptionException(this.optionEnum, "Option requires " + otherOption.longNameWithStarter);
        }
    }

    protected void checkArgumentCondition(boolean condition) throws SimTreeException {
        if (!condition) {
            throw new SimTreeOptionException(this.optionEnum, "Invalid or missing parameters");
        }
    }

    protected void checkArgumentCount(int count) throws SimTreeException {
        if (this.arguments.size() != count) {
            throw new SimTreeOptionException(this.optionEnum, "Exactly " + count + " parameter(s) required");
        }
    }

    protected int numericArgument(int argIndex) throws SimTreeException {
        int ret = 0;
        try {
            ret = new Integer((String)this.arguments.get(argIndex));
        }
        catch (NumberFormatException e) {
            throw new SimTreeOptionException(this.optionEnum, "Numeric argument required for option " + this.optionEnum.longName);
        }
        return ret;
    }

    public StringPair createConfigFileStringPair() {
        String inner = "";
        int j = 0;
        while (j < this.arguments.size()) {
            inner = String.valueOf(inner) + " " + (String)this.arguments.get(j);
            ++j;
        }
        return new StringPair(this.optionEnum.longName, inner);
    }

    protected String createCommandlineString() {
        String inner = this.getOptionEnum().longNameWithStarter;
        int j = 0;
        while (j < this.arguments.size()) {
            inner = String.valueOf(inner) + " " + (String)this.arguments.get(j);
            ++j;
        }
        return inner;
    }

    protected static Strings makeArgumentsFromString(String singleArg) {
        return new Strings(singleArg);
    }

    protected static Strings makeArgumentsFromStrings(String[] args) {
        Strings ret = new Strings();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            ret.add(s);
            ++n2;
        }
        return ret;
    }

    public static String option2commandline(OptionEnum optionEnum, String arguments) {
        String ret = " " + optionEnum.shortNameWithStarter;
        if (arguments != null) {
            ret = String.valueOf(ret) + " '" + arguments + "'";
        }
        return ret;
    }

    public static String option2commandline(OptionEnum optionEnum) {
        return Option.option2commandline(optionEnum, null);
    }

    protected boolean isFirstArgEqual(Option other) {
        return this.arguments.size() > 0 && other.arguments.size() > 0 && ((String)this.arguments.get(0)).equals(other.arguments.get(0));
    }

    protected static enum MergeModeEnum {
        ADD,
        CONFLICT,
        IGNORE,
        REPLACE,
        REPLACE_WHEN_1ARG_EQUAL_ELSE_IGNORE,
        REPLACE_WHEN_1ARG_EQUAL_ELSE_ADD;

    }

    protected static enum SaveConditionEnum {
        WHEN_FROM_COMMANDLINE_ONLY,
        ALWAYS,
        NEVER;

    }

    protected static enum SaveTargetEnum {
        GLOBAL_CONFIG_FILE_ONLY,
        CUSTOM_CONFIG_FILE_ONLY,
        ANY_CONFIG_FILE,
        NA;

    }
}

