/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.options;

import ikr.simtree.base.FileOPs;
import ikr.simtree.base.Helpers;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.SimTreeOptionException;
import ikr.simtree.commands.CommandEnum;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.OptionEnum;
import ikr.simtree.options.OptionSourceEnum;
import ikr.simtree.options.Options;
import ikr.simtree.options.SingleArgOption;
import ikr.simtree.vfs.StudyRootVFS;
import java.io.File;

public class LoadConfigOption
extends SingleArgOption {
    public LoadConfigOption(OptionEnum optionEnum, OptionSourceEnum source, SimTreeContext sc) {
        super(optionEnum, source, sc);
    }

    @Override
    protected boolean modifyOptions(Options optionList, CommandEnum commandEnum) throws SimTreeException {
        super.modifyOptions(optionList, commandEnum);
        String arg = this.getSingleArg();
        File file = new File(StudyRootVFS.getCustomConfigFileName(arg));
        if (!FileOPs.isFileReadable(file)) {
            throw new SimTreeOptionException(this.getOptionEnum(), "Cannot load configuration " + arg);
        }
        Options newOptions = Helpers.readOptionFile(file, OptionSourceEnum.CUSTOM_CONFIG_FILE, this.sc);
        optionList.remove(this);
        optionList.merge(newOptions);
        return true;
    }
}

