/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.launch;

import ikr.simtree.base.SimTreeException;
import ikr.simtree.commands.CommandEnum;
import ikr.simtree.control.ProcessList;
import ikr.simtree.launch.SimTreeCallbackHandler;
import ikr.simtree.launch.SimTreeEventEnum;
import ikr.simtree.runsim.ProcessScheduler;
import ikr.simtree.workingset.WorkingSet;
import java.util.ArrayList;

public class SimTreeContext {
    private ProcessScheduler currentProcessScheduler = null;
    private WorkingSet currentWorkingSet = null;
    private ProcessList currentProcessList = null;
    private CommandEnum currentCommand = null;
    private static int instanceNum = 0;
    private final String instanceStr;
    private final ArrayList<SimTreeCallbackHandler> callbackHandlers = new ArrayList();
    private boolean isVerbose;
    private boolean isVeryVerbose;

    public SimTreeContext() {
        this.instanceStr = instanceNum != 0 ? String.format("<%02d>", instanceNum) : "";
        ++instanceNum;
    }

    public void onEvent(SimTreeEventEnum simTreeEventEnum) {
        for (SimTreeCallbackHandler h : this.callbackHandlers) {
            h.onSimTreeEvent(simTreeEventEnum);
        }
    }

    public void addCallbackHandler(SimTreeCallbackHandler h) {
        this.callbackHandlers.add(h);
    }

    public void setCurrentProcessScheduler(ProcessScheduler currentProcessScheduler) {
        assert (currentProcessScheduler != null);
        assert (this.currentProcessScheduler == null);
        this.currentProcessScheduler = currentProcessScheduler;
    }

    public ProcessScheduler getCurrentProcessScheduler() {
        return this.currentProcessScheduler;
    }

    public void setCurrentWorkingSet(WorkingSet currentWorkingSet) {
        assert (currentWorkingSet != null);
        assert (this.currentWorkingSet == null);
        this.currentWorkingSet = currentWorkingSet;
    }

    public void setCurrentProcessList(ProcessList currentProcessList) {
        assert (currentProcessList != null);
        assert (this.currentProcessList == null);
        this.currentProcessList = currentProcessList;
    }

    public WorkingSet getCurrentWorkingSet() {
        return this.currentWorkingSet;
    }

    public ProcessList getCurrentProcessList() throws SimTreeException {
        if (this.currentProcessList == null) {
            throw new SimTreeException("No current process list");
        }
        return this.currentProcessList;
    }

    public void setCurrentCommand(CommandEnum commandEnum) {
        assert (this.currentCommand == null);
        assert (commandEnum != null);
        this.currentCommand = commandEnum;
    }

    public CommandEnum getCurrentCommand() {
        return this.currentCommand;
    }

    public void setIsVerbose() {
        this.isVerbose = true;
    }

    public void setIsVeryVerbose() {
        this.isVerbose = true;
        this.isVeryVerbose = true;
    }

    public boolean isVerbose() {
        return this.isVerbose;
    }

    public boolean isVeryVerbose() {
        return this.isVeryVerbose;
    }

    public static String instanceStr(SimTreeContext sc) {
        if (sc == null) {
            return "";
        }
        return sc.instanceStr;
    }
}

