/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.help;

import ikr.simtree.base.SHelpers;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.StringPair;
import ikr.simtree.base.StringPairs;
import ikr.simtree.base.Strings;
import ikr.simtree.help.HelpPara;
import ikr.simtree.help.HelpParaTypeEnum;

public class TwoColHelpPara
extends HelpPara {
    public final StringPairs colContent = new StringPairs();
    public final int colGap;

    public TwoColHelpPara(HelpParaTypeEnum paraType, int indent, StringPair line, int gap) {
        this(paraType, indent, gap);
        this.colContent.add(line);
    }

    public TwoColHelpPara(HelpParaTypeEnum paraType, int indent, int gap) {
        super(paraType, null, indent);
        this.colGap = gap;
    }

    public void addLine(String left, String right) {
        this.colContent.add(new StringPair(left, right));
    }

    public void addLine(StringPair line) {
        this.colContent.add(line);
    }

    @Override
    public Strings getPlainContent() {
        Strings ret = new Strings();
        for (StringPair p : this.colContent) {
            ret.addAll(TwoColHelpPara.printToCol(TwoColHelpPara.getPlainContentLine(p.firstStr), TwoColHelpPara.getPlainContentLine(p.secondStr), this.colGap));
        }
        return ret;
    }

    @Override
    public Strings getContent() {
        assert (false);
        return null;
    }

    private static Strings printToCol(String left, String right, int distCol) {
        Strings ret = new Strings();
        int fill = distCol - left.length();
        if (fill >= 1) {
            ret.add(String.valueOf(left) + SHelpers.blanks(fill, true) + right);
        } else {
            ret.add(left);
            ret.add(String.valueOf(SHelpers.blanks(distCol, true)) + right);
        }
        return ret;
    }

    @Override
    protected boolean doReformat() {
        return false;
    }

    @Override
    public Strings getHTMLContent() throws SimTreeException {
        assert (this.crossRef == null);
        Strings ret = new Strings();
        ret.add("<table>");
        for (StringPair p : this.colContent) {
            ret.add("<tr>");
            ret.add("<td class=\"left_col\">" + TwoColHelpPara.getHTMLContentLine(p.firstStr) + "&nbsp;&nbsp;</td><td>" + TwoColHelpPara.getHTMLContentLine(p.secondStr) + "</td>");
            ret.add("</tr>");
        }
        ret.add("</table>");
        return ret;
    }
}

