/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.help;

import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.Strings;
import ikr.simtree.help.CrossRef;
import ikr.simtree.help.HelpPara;
import ikr.simtree.help.HelpParaTypeEnum;

public class SimpleHelpPara
extends HelpPara {
    private Strings content;

    public SimpleHelpPara(HelpParaTypeEnum paraType, int indent, String content) {
        super(paraType, null, indent);
        this.setContent(new Strings(content));
    }

    public SimpleHelpPara(HelpParaTypeEnum paraType, CrossRef crossRef, int indent, String content) {
        super(paraType, crossRef, indent);
        this.setContent(new Strings(content));
    }

    public SimpleHelpPara(HelpParaTypeEnum paraType, int indent, Strings content) {
        super(paraType, null, indent);
        this.setContent(content);
    }

    protected void setContent(Strings content) {
        if (content.size() != 0 && ((String)content.get(0)).trim().length() == 0) {
            content.remove(0);
        }
        this.content = content;
    }

    @Override
    public Strings getPlainContent() {
        return SimpleHelpPara.getPlainContentLines(this.content);
    }

    @Override
    public Strings getContent() {
        return this.content;
    }

    @Override
    protected boolean doReformat() {
        return true;
    }

    protected String getNumberString() {
        return null;
    }

    @Override
    public Strings getHTMLContent() throws SimTreeException {
        String preTag = "";
        String postTag = "";
        String crossRefString = "";
        String numberStringStart = this.getNumberString();
        String numberStringEnd = "";
        if (numberStringStart != null) {
            numberStringStart = "<A ID=\"toc-" + numberStringStart + "\">";
            numberStringEnd = "</A>";
        } else {
            numberStringStart = "";
        }
        if (this.crossRef != null) {
            crossRefString = " id=\"" + this.crossRef.toRefName() + "\"";
        }
        switch (this.helpParaTypeEnum) {
            case E0: {
                preTag = "<p" + crossRefString + ">";
                postTag = "</p>";
                break;
            }
            case E1: {
                assert (this.doReformat());
                preTag = "<table><tr><td nowrap width=22 valign=\"top\">&nbsp;</td><td><p" + crossRefString + ">";
                postTag = "</p></td></tr></table>";
                break;
            }
            case E2: {
                assert (this.doReformat());
                preTag = "<table><tr><td nowrap width=22 valign=\"top\">&nbsp;</td><td nowrap width=22 valign=\"top\">&nbsp;</td><td><p" + crossRefString + ">";
                postTag = "</p></td></tr></table>";
                break;
            }
            case EP1: {
                assert (this.doReformat());
                assert (this.crossRef == null);
                preTag = "<table><tr><td nowrap width=22 valign=\"top\">&bull;</td><td><p>";
                postTag = "</p></td></tr></table>";
                break;
            }
            case EP2: {
                assert (this.doReformat());
                assert (this.crossRef == null);
                preTag = "<table><tr><td nowrap width=22 valign=\"top\">&nbsp;</td><td nowrap width=22 valign=\"top\">&bull;</td><td><p>";
                postTag = "</p></td></tr></table>";
                break;
            }
            case H1: {
                assert (this.doReformat());
                preTag = "<h1" + crossRefString + ">" + numberStringStart;
                postTag = String.valueOf(numberStringEnd) + "</h1>";
                break;
            }
            case H2: {
                assert (this.doReformat());
                preTag = "<h2" + crossRefString + ">" + numberStringStart;
                postTag = String.valueOf(numberStringEnd) + "</h2>";
                break;
            }
            case H3: {
                assert (this.doReformat());
                preTag = "<h3" + crossRefString + ">" + numberStringStart;
                postTag = String.valueOf(numberStringEnd) + "</h3>";
                break;
            }
            case H4: {
                assert (this.doReformat());
                preTag = "<h4" + crossRefString + ">" + numberStringStart;
                postTag = String.valueOf(numberStringEnd) + "</h4>";
                break;
            }
            case CMD: {
                assert (this.crossRef == null);
                preTag = "<p class=\"help_exam\"># ";
                postTag = "</p>";
                break;
            }
            case CMD_HELP: {
                assert (this.doReformat());
                assert (this.crossRef == null);
                preTag = "<p class=help_expl>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
                postTag = "</p>";
            }
        }
        Strings ret = new Strings();
        ret.add(preTag);
        ret.addAll(SimpleHelpPara.getHTMLContentLines(this.content, this.doReformat()));
        ret.add(postTag);
        return ret;
    }
}

