/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.help;

import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.Strings;
import ikr.simtree.help.HelpFileReader;
import ikr.simtree.help.HelpPara;
import ikr.simtree.help.HelpParaTypeEnum;
import ikr.simtree.help.HelpParas;
import ikr.simtree.help.SimpleHelpPara;

public abstract class HelpTextExtractor {
    public static String getHelpTextLine(String helpClass, String helpTopic, String helpSubTopic) throws SimTreeException {
        HelpParas helpParas = new HelpFileReader(helpClass, helpTopic).getHelpFileParas(helpSubTopic, 0);
        Strings help = null;
        if (helpParas != null) {
            help = new Strings();
            for (HelpPara p : helpParas) {
                help.addAll(p.getPlainContent());
            }
        }
        if (help != null) {
            return help.toSingleString();
        }
        return "";
    }

    public static HelpParas getHelpSectionParas(int indent, String sectionTitle, String helpClass, String helpTopic, String helpSubTopic) throws SimTreeException {
        HelpParas helpParas = new HelpFileReader(helpClass, helpTopic).getHelpFileParas(helpSubTopic, sectionTitle != null ? indent + 1 : indent);
        HelpParas ret = new HelpParas();
        if (helpParas != null && helpParas.size() != 0) {
            if (sectionTitle != null) {
                ret.add(new SimpleHelpPara(HelpParaTypeEnum.H4, indent, sectionTitle));
            }
            ret.addAll(helpParas);
        }
        return ret;
    }
}

