/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.gui.tree;

import ikr.simtree.base.Props;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.gui.MainFrame;
import ikr.simtree.gui.TabTypeEnum;
import ikr.simtree.gui.tree.TreeViewerPanel;
import ikr.simtree.gui.tree.ValueInTree;
import ikr.simtree.launch.SimTreeContext;
import javax.swing.tree.DefaultMutableTreeNode;

public class ValueTree {
    private int currentLevel = 0;
    private final DefaultMutableTreeNode[] currentNodeArr;
    private final SimTreeContext sc;

    public ValueTree(ValueInTree treeValueForTopNode, SimTreeContext sc) throws SimTreeException {
        this.currentNodeArr = new DefaultMutableTreeNode[Props.getInt("st.i.max_eval_printserver_depth.1")];
        this.currentNodeArr[0] = new DefaultMutableTreeNode(treeValueForTopNode);
        this.sc = sc;
    }

    public ValueTree(DefaultMutableTreeNode topNode, SimTreeContext sc) {
        this.currentNodeArr = new DefaultMutableTreeNode[1];
        this.currentNodeArr[0] = topNode;
        this.sc = sc;
    }

    public void addEntry(ValueInTree value, int depth) throws SimTreeException {
        assert (depth >= 1);
        try {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(value);
            if (depth == this.currentLevel + 1) {
                this.currentNodeArr[this.currentLevel].add(node);
            } else if (depth > this.currentLevel + 1) {
                ++this.currentLevel;
                assert (depth == this.currentLevel + 1);
                this.currentNodeArr[this.currentLevel].add(node);
            } else {
                assert (depth >= 1);
                this.currentLevel = depth - 1;
                this.currentNodeArr[this.currentLevel].add(node);
            }
            this.currentNodeArr[this.currentLevel + 1] = node;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SimTreeException("Tree too deep, increase value of property st.i.max_eval_printserver_depth.1");
        }
    }

    public void createView(TabTypeEnum tabType, String longTitle, boolean expandAll) {
        MainFrame.addTabPanelToMainTab(new TreeViewerPanel(tabType, longTitle, this.currentNodeArr[0], expandAll, this.sc));
    }
}

