/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.gui.tree;

import ikr.simtree.base.Message;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.Strings;
import ikr.simtree.commands.CommandDesc;
import ikr.simtree.commands.CommandEnum;
import ikr.simtree.commands.CommandVariantEnum;
import ikr.simtree.gui.AddToChartMenuGenerator;
import ikr.simtree.gui.chart.ChartDataCollectorFactory;
import ikr.simtree.gui.dialogs.SimParaDialog;
import ikr.simtree.gui.tree.ValueInTree;
import ikr.simtree.launch.SimTreeCallbackHandler;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.launch.SimTreeEventEnum;
import ikr.simtree.launch.SimTreeLauncher;
import ikr.simtree.options.ColumnDefinitionOption;
import ikr.simtree.options.OptionEnum;
import ikr.simtree.simpara.SimPara;
import ikr.simtree.simpara.SimParaFragments;
import ikr.simtree.simpara.SimParaPath;
import ikr.simtree.simpara.SimParaTypeEnum;
import ikr.simtree.vfs.results.node.SimulationMethodEnum;
import ikr.simtree.vfs.results.tree.ResultsTreeState;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;

public class ValueInTreeForList
extends ValueInTree
implements SimTreeCallbackHandler {
    private static final String VIEW_FINALRESULTS = "View Final Results";
    private static final String VIEW_PARTIALRESULTS_BATCHES = "View Batch Results";
    private static final String VIEW_PARTIALRESULTS_DROPS = "View Drop Results";
    private static final String ADD_SIMPARA = "Add Simulation Parameter";
    private static final String ADD_SIMPARA_VALUES = "Add Simulation Parameter Values";
    private final Strings contentLines;
    private final SimParaPath simParaPath;
    private final boolean hasFinalResults;
    private final Strings partialResultNames;

    public ValueInTreeForList(String valueString, Strings contentLines, SimParaPath simParaPath, boolean hasFinalResults, Strings partialResultNames, SimTreeContext sc) {
        super(valueString, sc);
        this.contentLines = contentLines;
        this.simParaPath = simParaPath;
        this.hasFinalResults = hasFinalResults;
        this.partialResultNames = partialResultNames;
    }

    private void addSimulationParameterValues(SimParaFragments simParaWithValues) {
        assert (simParaWithValues.isValid());
        SimTreeLauncher simTreeLauncher = new SimTreeLauncher(new CommandDesc(CommandEnum.ADD, null));
        simTreeLauncher.addOption(OptionEnum.SIMULATION_PARAMETER, simParaWithValues.getSimParaName(), simParaWithValues.getSimParaType().typeName, simParaWithValues.getValueStrings());
        simTreeLauncher.getSimTreeContext().addCallbackHandler(this);
        simTreeLauncher.startInstance();
    }

    @Override
    public void addNodeSpecificContextMenuItems(JPopupMenu popupMenu, Font font, TreePath treePath) throws SimTreeException {
        JMenuItem menuItem;
        boolean sepAdded = false;
        if (this.simParaPath != null && this.simParaPath.size() != 0 && this.hasFinalResults) {
            menuItem = new JMenuItem(VIEW_FINALRESULTS);
            menuItem.setFont(font);
            menuItem.addMouseListener(new PopupMouseAdapter());
            popupMenu.addSeparator();
            sepAdded = true;
            popupMenu.add(menuItem);
        }
        if (this.simParaPath != null && this.simParaPath.size() != 0 && this.partialResultNames != null && this.partialResultNames.size() != 0) {
            SimulationMethodEnum simulationMethod = ResultsTreeState.getSimulationMethod(true, this.sc);
            String n = simulationMethod == SimulationMethodEnum.BATCH_MEAN ? VIEW_PARTIALRESULTS_BATCHES : VIEW_PARTIALRESULTS_DROPS;
            JMenu partialResultMenu = new JMenu(n);
            partialResultMenu.setFont(font);
            for (String s : this.partialResultNames) {
                JMenuItem sub = new JMenuItem(s);
                sub.setFont(font);
                sub.addMouseListener(new PopupMouseAdapter());
                partialResultMenu.add(sub);
            }
            if (!sepAdded) {
                popupMenu.addSeparator();
            }
            popupMenu.add(partialResultMenu);
        }
        if (this.simParaPath == null) {
            menuItem = new JMenuItem(ADD_SIMPARA);
            menuItem.setFont(font);
            menuItem.addMouseListener(new PopupMouseAdapter());
            popupMenu.addSeparator();
            popupMenu.add(menuItem);
        }
        if (this.simParaPath != null) {
            menuItem = new JMenuItem(ADD_SIMPARA_VALUES);
            menuItem.setFont(font);
            menuItem.addMouseListener(new PopupMouseAdapter());
            popupMenu.addSeparator();
            popupMenu.add(menuItem);
        }
        if (this.simParaPath != null && this.simParaPath.size() != 0) {
            AddToChartMenuGenerator.addChartContextMenuItems(popupMenu, font, new PopupMouseAdapter(), true);
        }
    }

    @Override
    public void onNodeSelected() {
    }

    @Override
    public void onSimTreeEvent(SimTreeEventEnum simTreeEventEnum) {
        switch (simTreeEventEnum) {
            case SIMTREE_INSTANCE_FINISHED: {
                SimTreeLauncher simTreeLauncher = new SimTreeLauncher(new CommandDesc(CommandEnum.LIST, CommandVariantEnum.VISUAL));
                simTreeLauncher.startInstance();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private class PopupMouseAdapter
    extends MouseAdapter {
        private PopupMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            String menuText = ((JMenuItem)e.getSource()).getText();
            if (ValueInTreeForList.this.simParaPath == null || ValueInTreeForList.this.simParaPath.size() == 0) {
                if (menuText.equals(ValueInTreeForList.ADD_SIMPARA)) {
                    SimParaFragments simParaDialogValues = new SimParaDialog(new SimParaFragments()).getEnteredValue();
                    if (simParaDialogValues == null) {
                        return;
                    }
                    ValueInTreeForList.this.addSimulationParameterValues(simParaDialogValues);
                }
                return;
            }
            String simParaName = ((SimPara)ValueInTreeForList.this.simParaPath.get(ValueInTreeForList.this.simParaPath.size() - 1)).getParaName();
            if (menuText.equals("as X Axis value")) {
                ChartDataCollectorFactory.getCurrentChartDataCollector().setxAxisString(ColumnDefinitionOption.ColKindEnum.SIMULATION_PARAMETER, simParaName);
            } else if (menuText.equals("as Y Axis value")) {
                ChartDataCollectorFactory.getCurrentChartDataCollector().setyAxisString(ColumnDefinitionOption.ColKindEnum.SIMULATION_PARAMETER, simParaName);
            } else if (menuText.equals("as family value")) {
                ChartDataCollectorFactory.getCurrentChartDataCollector().setFamilyString(ColumnDefinitionOption.ColKindEnum.SIMULATION_PARAMETER, simParaName);
            } else if (menuText.equals("as constraint")) {
                ChartDataCollectorFactory.getCurrentChartDataCollector().addSPConstraint((SimPara)ValueInTreeForList.this.simParaPath.get(ValueInTreeForList.this.simParaPath.size() - 1));
            } else if (menuText.equals(ValueInTreeForList.VIEW_FINALRESULTS)) {
                SimTreeLauncher simTreeCaller = new SimTreeLauncher(new CommandDesc(CommandEnum.DUMP, CommandVariantEnum.VISUAL));
                simTreeCaller.addOption(OptionEnum.SIMULATION_PARAMETER_PATH, ValueInTreeForList.this.simParaPath.toFormattedString(SimPara.FormatEnum.OPTION_SPP));
                simTreeCaller.startInstance();
            } else if (menuText.equals(ValueInTreeForList.ADD_SIMPARA_VALUES)) {
                SimParaTypeEnum type = ((SimPara)ValueInTreeForList.this.simParaPath.get(ValueInTreeForList.this.simParaPath.size() - 1)).getParaType();
                SimParaFragments simParaDialogValues = new SimParaDialog(new SimParaFragments(simParaName, type)).getEnteredValue();
                if (simParaDialogValues == null) {
                    return;
                }
                ValueInTreeForList.this.addSimulationParameterValues(simParaDialogValues);
            } else {
                SimTreeLauncher simTreeCaller = new SimTreeLauncher(new CommandDesc(CommandEnum.DUMP, CommandVariantEnum.VISUAL));
                simTreeCaller.addOption(OptionEnum.SIMULATION_PARAMETER_PATH, ValueInTreeForList.this.simParaPath.toFormattedString(SimPara.FormatEnum.OPTION_SPP));
                SimulationMethodEnum simulationMethod = null;
                try {
                    simulationMethod = ResultsTreeState.getSimulationMethod(true, ValueInTreeForList.this.sc);
                }
                catch (SimTreeException e1) {
                    Message.fatal(e1.getMessage(), ValueInTreeForList.this.sc);
                }
                if (simulationMethod == SimulationMethodEnum.BATCH_MEAN) {
                    simTreeCaller.addOption(OptionEnum.BATCHES, menuText);
                } else {
                    simTreeCaller.addOption(OptionEnum.DROPS, menuText);
                }
                simTreeCaller.startInstance();
            }
        }
    }
}

