/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.gui.chart;

import ikr.simtree.base.Strings;
import ikr.simtree.commands.CommandDesc;
import ikr.simtree.commands.CommandEnum;
import ikr.simtree.commands.CommandVariantEnum;
import ikr.simtree.graphwriter.GraphWriterEnum;
import ikr.simtree.gui.TabPanel;
import ikr.simtree.gui.TabTypeEnum;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.launch.SimTreeLauncher;
import ikr.simtree.options.ColumnDefinitionOption;
import ikr.simtree.options.OptionEnum;
import ikr.simtree.simpara.SimPara;
import ikr.simtree.simpara.SimParaPath;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ChartDataCollectorPanel
extends TabPanel {
    private final JEditorPane editorPane;
    private final JButton createChartButton;
    private final JButton deleteXButton;
    private final JButton deleteYButton;
    private final JButton deleteFamilyButton;
    private final JButton deleteConstraintsButton;
    private String xAxisString;
    private String yAxisString;
    private String familyString;
    private ColumnDefinitionOption.ColKindEnum xAxisColKindEnum;
    private ColumnDefinitionOption.ColKindEnum yAxisColKindEnum;
    private ColumnDefinitionOption.ColKindEnum familyColKindEnum;
    private SimParaPath constraints = new SimParaPath();

    public ChartDataCollectorPanel(SimTreeContext sc) {
        super("Chart Data Collector", sc, TabTypeEnum.CHART_DATA);
        this.editorPane = new JEditorPane();
        this.editorPane.setEditable(false);
        this.editorPane.setContentType("text/html");
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(this.editorPane);
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPane, "Center");
        JPanel buttonPanel = new JPanel(new BorderLayout());
        this.createChartButton = new JButton("Create chart");
        this.createChartButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChartDataCollectorPanel.this.createChart();
                ChartDataCollectorPanel.this.updateEditorPane();
                ChartDataCollectorPanel.this.setButtonStatus();
            }
        });
        JPanel createChartButtonPanel = new JPanel(new FlowLayout());
        createChartButtonPanel.add(this.createChartButton);
        JPanel rightPanel = new JPanel(new FlowLayout());
        this.deleteXButton = new JButton("Delete X Axis");
        this.deleteXButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChartDataCollectorPanel.this.xAxisString = null;
                ChartDataCollectorPanel.this.updateEditorPane();
                ChartDataCollectorPanel.this.setButtonStatus();
            }
        });
        this.deleteYButton = new JButton("Delete Y Axis");
        this.deleteYButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChartDataCollectorPanel.this.yAxisString = null;
                ChartDataCollectorPanel.this.updateEditorPane();
                ChartDataCollectorPanel.this.setButtonStatus();
            }
        });
        this.deleteFamilyButton = new JButton("Delete Family");
        this.deleteFamilyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChartDataCollectorPanel.this.familyString = null;
                ChartDataCollectorPanel.this.updateEditorPane();
                ChartDataCollectorPanel.this.setButtonStatus();
            }
        });
        this.deleteConstraintsButton = new JButton("Delete Constraints");
        this.deleteConstraintsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChartDataCollectorPanel.this.constraints = new SimParaPath();
                ChartDataCollectorPanel.this.updateEditorPane();
                ChartDataCollectorPanel.this.setButtonStatus();
            }
        });
        rightPanel.add(this.deleteXButton);
        rightPanel.add(this.deleteYButton);
        rightPanel.add(this.deleteFamilyButton);
        rightPanel.add(this.deleteConstraintsButton);
        buttonPanel.add((Component)createChartButtonPanel, "West");
        buttonPanel.add((Component)rightPanel, "East");
        this.add((Component)buttonPanel, "South");
        this.updateEditorPane();
        this.setButtonStatus();
    }

    public void setxAxisString(ColumnDefinitionOption.ColKindEnum xAxisColKindEnum, String xAxisString) {
        assert (xAxisColKindEnum != ColumnDefinitionOption.ColKindEnum.BATCH_NUMBER);
        this.xAxisColKindEnum = xAxisColKindEnum;
        this.xAxisString = xAxisString;
        this.updateEditorPane();
        this.setButtonStatus();
    }

    public void setyAxisString(ColumnDefinitionOption.ColKindEnum yAxisColKindEnum, String yAxisString) {
        assert (yAxisColKindEnum != ColumnDefinitionOption.ColKindEnum.BATCH_NUMBER);
        this.yAxisColKindEnum = yAxisColKindEnum;
        this.yAxisString = yAxisString;
        this.updateEditorPane();
        this.setButtonStatus();
    }

    public void addSPConstraint(SimPara simPara) {
        this.constraints.add(simPara);
        this.updateEditorPane();
        this.setButtonStatus();
    }

    public void setFamilyString(ColumnDefinitionOption.ColKindEnum familyColKindEnum, String familyString) {
        assert (familyColKindEnum != ColumnDefinitionOption.ColKindEnum.BATCH_NUMBER);
        this.familyString = familyString;
        this.familyColKindEnum = familyColKindEnum;
        this.updateEditorPane();
        this.setButtonStatus();
    }

    private void setButtonStatus() {
        this.createChartButton.setEnabled(this.xAxisString != null && this.yAxisString != null);
        this.deleteXButton.setEnabled(this.xAxisString != null);
        this.deleteYButton.setEnabled(this.yAxisString != null);
        this.deleteFamilyButton.setEnabled(this.familyString != null);
        this.deleteConstraintsButton.setEnabled(this.constraints.size() != 0);
    }

    private void createChart() {
        SimTreeLauncher simTreeCaller = new SimTreeLauncher(new CommandDesc(CommandEnum.EVAL, CommandVariantEnum.VISUAL));
        simTreeCaller.addOption(OptionEnum.GRAPH_WRITER, GraphWriterEnum.FLAT.longName);
        simTreeCaller.addOption(OptionEnum.COLUMN_DEFINITION, "0", this.xAxisColKindEnum.longName, this.xAxisString);
        simTreeCaller.addOption(OptionEnum.COLUMN_DEFINITION, "1", this.yAxisColKindEnum.longName, this.yAxisString);
        if (this.familyString != null) {
            simTreeCaller.addOption(OptionEnum.COLUMN_DEFINITION, "2", this.familyColKindEnum.longName, this.familyString);
            simTreeCaller.addOption(OptionEnum.GRAPH_WRITER, GraphWriterEnum.FAMILY.longName, "2");
        } else {
            simTreeCaller.addOption(OptionEnum.GRAPH_WRITER, GraphWriterEnum.FLAT.longName);
        }
        for (SimParaWithValues s : this.createConsolidatedConstraintsList()) {
            simTreeCaller.addOption(OptionEnum.SIMULATION_PARAMETER, s.simParaName, s.values);
        }
        simTreeCaller.startInstance();
    }

    /*
     * Unable to fully structure code
     */
    private ArrayList<SimParaWithValues> createConsolidatedConstraintsList() {
        ret = new ArrayList<SimParaWithValues>();
        constraintsClone = this.constraints.clonePath();
        if (ChartDataCollectorPanel.$assertionsDisabled || constraintsClone != null) ** GOTO lbl15
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            simParaWithValues = new SimParaWithValues(((SimPara)constraintsClone.get(0)).getParaName());
            i = 0;
            while (((SimPara)constraintsClone.get(i)).getParaName().equals(((SimPara)constraintsClone.get(0)).getParaName())) {
                simParaWithValues.addValue(((SimPara)constraintsClone.get(i)).getStringValue());
                constraintsClone.remove(0);
                if (++i >= constraintsClone.size()) break;
            }
            ret.add(simParaWithValues);
lbl15:
            // 2 sources

            ** while (constraintsClone.size() != 0)
        }
lbl16:
        // 1 sources

        return ret;
    }

    private static Strings createSection(String name, Strings content) {
        Strings section = new Strings();
        section.add("<DT>");
        section.add("<H3 font face='sans'>" + name + "</H3>");
        section.add("</DT>");
        section.add("<DD>");
        for (String s : content) {
            section.add("<p font face='sans'>" + s + "</P>");
        }
        section.add("</DD>");
        return section;
    }

    private void updateEditorPane() {
        Strings content = new Strings();
        content.add("<DL>");
        if (this.xAxisString != null) {
            content.addAll(ChartDataCollectorPanel.createSection("X Axis", new Strings(this.xAxisString)));
        }
        if (this.yAxisString != null) {
            content.addAll(ChartDataCollectorPanel.createSection("Y Axis", new Strings(this.yAxisString)));
        }
        if (this.familyString != null) {
            content.addAll(ChartDataCollectorPanel.createSection("Family", new Strings(this.familyString)));
        }
        if (this.constraints.size() != 0) {
            Strings c = new Strings();
            for (SimPara simPara : this.constraints) {
                c.add(simPara.toFormattedString(SimPara.FormatEnum.PLAIN));
            }
            content.addAll(ChartDataCollectorPanel.createSection("Constraints", c));
        }
        content.add("</DL>");
        this.editorPane.setText(content.toSingleString());
    }

    private class SimParaWithValues {
        public final String simParaName;
        public final Strings values = new Strings();

        public SimParaWithValues(String simParaName) {
            this.simParaName = simParaName;
        }

        public void addValue(String val) {
            for (String s : this.values) {
                if (!s.equals(val)) continue;
                return;
            }
            this.values.add(val);
        }
    }
}

