/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.gui;

import ikr.simtree.base.Message;
import ikr.simtree.gui.TabLabelWithCloseButton;
import ikr.simtree.gui.TabPanel;
import ikr.simtree.gui.TabTypeEnum;
import ikr.simtree.vfs.StudyRootVFS;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class MainFrame
extends JFrame {
    private static boolean isGUIRunning = false;
    private static final int pxHeight = 750;
    private static final int pxWidth = 1200;
    private static final Font font = new Font("Dialog", 1, 18);
    private static final int leftMargin = 6;
    private static JTabbedPane tabMain;

    public MainFrame(String title) {
        super(title);
        isGUIRunning = true;
        this.setLayout(new BorderLayout());
        JPanel titlePanel = new JPanel();
        JLabel titleLabel = new JLabel(title);
        titleLabel.setFont(font);
        titlePanel.setLayout(new BorderLayout());
        titlePanel.add((Component)titleLabel, "Center");
        titlePanel.setBorder(new EmptyBorder(new Insets(12, 6, 0, 6)));
        this.add((Component)titlePanel, "North");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                isGUIRunning = false;
            }
        });
        JPanel lowerPanel = new JPanel(new BorderLayout());
        lowerPanel.setBorder(new EmptyBorder(new Insets(0, 6, 10, 6)));
        JPanel panelSysMessage = new JPanel(new BorderLayout());
        JScrollPane scrollPanelSysMessage = new JScrollPane();
        JTextArea textSysMessage = new JTextArea();
        scrollPanelSysMessage.add(textSysMessage);
        scrollPanelSysMessage.setViewportView(textSysMessage);
        panelSysMessage.add((Component)scrollPanelSysMessage, "Center");
        lowerPanel.add((Component)panelSysMessage, "Center");
        this.add((Component)lowerPanel, "South");
        textSysMessage.setRows(9);
        textSysMessage.setEditable(false);
        Message.setSysMessageWindow(textSysMessage);
        this.setDefaultCloseOperation(2);
        JPanel panelTab = new JPanel();
        panelTab.setLayout(new BoxLayout(panelTab, 0));
        tabMain = new JTabbedPane();
        tabMain.setBorder(new EmptyBorder(new Insets(11, 6, 11, 6)));
        tabMain.setFont(new Font("Dialog", 0, 14));
        panelTab.add(tabMain);
        JPanel panelInnerFrame = new JPanel();
        panelInnerFrame.setLayout(new BorderLayout());
        panelInnerFrame.add((Component)panelTab, "Center");
        this.getContentPane().add((Component)panelInnerFrame, "Center");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 1200) / 2, (screenSize.height - 750) / 2, 1200, 750);
        this.setVisible(true);
    }

    public static void addTabPanelToMainTab(TabPanel tabPanel) {
        if (tabMain == null) {
            String mainTitle = StudyRootVFS.getStudyRoot() != null ? "StudyRoot [" + StudyRootVFS.getStudyRoot() + "]" : "Standalone Viewer";
            new MainFrame(mainTitle);
        }
        if (tabPanel.getTabTypeEnum() == TabTypeEnum.LIST_TREE) {
            if (tabMain.getTabCount() != 0) {
                assert (((TabPanel)tabMain.getComponentAt(0)).getTabTypeEnum() == TabTypeEnum.LIST_TREE);
                tabMain.remove(0);
            }
            tabMain.insertTab(tabPanel.getTabTitle(), null, tabPanel, tabPanel.longTitle, 0);
            tabMain.setSelectedIndex(0);
        } else {
            int tabIndex = tabMain.getTabCount();
            tabMain.insertTab(tabPanel.getTabTitle(), null, tabPanel, tabPanel.longTitle, tabIndex);
            tabMain.setTabComponentAt(tabIndex, new TabLabelWithCloseButton(tabMain, tabPanel.getTabTitle()));
        }
    }

    public static void removeTabPanelFromMainTab(TabPanel tabPanel) {
        assert (tabMain != null);
        tabMain.remove(tabPanel);
    }

    public static boolean containsPanel(TabPanel tabPanel) {
        return tabMain.indexOfComponent(tabPanel) != -1;
    }

    public static boolean isGUIRunning() {
        return isGUIRunning;
    }
}

