/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.graphwriter;

import ikr.simtree.base.SimTreeException;
import ikr.simtree.graphwriter.PrintServerPath;
import java.util.ArrayList;

public class ResultPath {
    private final PrintServerPath unmodifiedPath;
    private final String resultName;
    private PrintServerPath expandedPath;
    private boolean wasExpanded = false;

    public ResultPath(String resultName, PrintServerPath unmodifiedPath) {
        assert (resultName != null && resultName.length() != 0);
        this.resultName = resultName;
        assert (unmodifiedPath != null);
        this.unmodifiedPath = unmodifiedPath;
    }

    public PrintServerPath getUnmodifiedPath() {
        return this.unmodifiedPath;
    }

    public PrintServerPath getExpandedPath() {
        assert (this.expandedPath != null);
        return this.expandedPath;
    }

    public String getResultName() {
        return this.resultName;
    }

    public boolean isWasExpanded() {
        return this.wasExpanded;
    }

    public void expand(ArrayList<ResultPath> resultSources) throws SimTreeException {
        PrintServerPath currentPath = this.unmodifiedPath.clone();
        boolean finish = false;
        while (!finish) {
            PrintServerPath oldPath = currentPath;
            currentPath = new PrintServerPath();
            finish = true;
            for (String oldEle : oldPath) {
                if (oldEle.contains("%")) {
                    finish = false;
                    if (!oldEle.startsWith("%") || !oldEle.endsWith("%")) {
                        throw new SimTreeException("Invalid expansion string, must start and end with %");
                    }
                    String replName = oldEle.substring(1, oldEle.length() - 1);
                    assert (replName.length() != 0);
                    if (replName.equals(this.resultName)) {
                        throw new SimTreeException("Recursive expansion not possible");
                    }
                    boolean found = false;
                    for (ResultPath rs : resultSources) {
                        if (rs == this || !rs.getResultName().equals(replName)) continue;
                        PrintServerPath replStrings = rs.getUnmodifiedPath().clone();
                        currentPath.addAll(replStrings);
                        found = true;
                        this.wasExpanded = true;
                    }
                    if (found) continue;
                    throw new SimTreeException("Expansion failed, " + replName + " not found");
                }
                currentPath.add(oldEle);
            }
        }
        this.expandedPath = currentPath;
    }
}

