/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.graphwriter;

import ikr.simtree.base.Message;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.graphdata.GraphData;
import ikr.simtree.graphwriter.GraphWriterI;
import ikr.simtree.gui.chart.ChartLayout;
import ikr.simtree.gui.chart.ChartViewer;
import ikr.simtree.launch.SimTreeContext;
import java.util.List;

public abstract class GraphWriter
implements GraphWriterI {
    protected String[] additionalArguments;
    protected GraphData graphData;
    private final boolean visual;
    private final SimTreeContext sc;
    private final ChartViewer chartViewer;

    protected GraphWriter(boolean visual, SimTreeContext sc) {
        this.visual = visual;
        this.sc = sc;
        this.chartViewer = visual ? new ChartViewer() : null;
    }

    protected void printOneTable(String tableHeader, List<String>[] graphDataList, String indent) {
        if (this.visual) {
            this.chartViewer.addTableToChart(tableHeader, graphDataList);
        } else {
            this.printOneTableAsText(tableHeader, graphDataList, indent);
        }
    }

    private void printOneTableAsText(String tableHeader, List<String>[] graphDataList, String indent) {
        assert (this.graphData.getGraphHeadlineElements().length == graphDataList.length);
        if (tableHeader != null) {
            Message.evalResult(tableHeader, this.sc);
        }
        String headLineStr = "";
        String[] stringArray = this.graphData.getGraphHeadlineElements();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String headLineElement = stringArray[n2];
            headLineStr = String.valueOf(headLineStr) + headLineElement + " ";
            ++n2;
        }
        Message.evalResult(String.valueOf(indent) + headLineStr, this.sc);
        int line = 0;
        while (line < graphDataList[0].size()) {
            String lineStr = "";
            int col = 0;
            while (col < graphDataList.length) {
                lineStr = String.valueOf(lineStr) + graphDataList[col].get(line) + " ";
                ++col;
            }
            Message.resultOut(String.valueOf(indent) + lineStr, "            ");
            ++line;
        }
    }

    protected void printGraph(boolean isFamilyGraphWriter) throws SimTreeException {
        if (this.visual) {
            ChartLayout chartLayout;
            if (isFamilyGraphWriter) {
                assert (this.additionalArguments != null && this.additionalArguments.length == 1);
                int familyCol = -1;
                try {
                    familyCol = new Integer(this.additionalArguments[0]);
                }
                catch (NumberFormatException e) {
                    throw new SimTreeException("Invalid col number " + this.additionalArguments[0]);
                }
                int colX = familyCol != 0 ? 0 : 1;
                int colY = familyCol != colX + 1 ? colX + 1 : colX + 2;
                chartLayout = new ChartLayout(colX, colY);
                if (familyCol >= this.graphData.getNumOfCols()) {
                    throw new SimTreeException("Invalid family column");
                }
            } else {
                chartLayout = new ChartLayout(0, 1);
            }
            if (chartLayout.colX >= this.graphData.getNumOfCols()) {
                throw new SimTreeException("Invalid value for x axis, not enough columns");
            }
            if (chartLayout.colY >= this.graphData.getNumOfCols()) {
                throw new SimTreeException("Invalid value for y axis, not enough columns");
            }
            this.chartViewer.createChart(chartLayout, this.graphData.getGraphHeadlineElements(), this.sc);
        }
    }

    @Override
    public void setGraphData(GraphData graphData) {
        this.graphData = graphData;
    }

    @Override
    public void setAdditionalArguments(String[] additionalArguments) {
        this.additionalArguments = additionalArguments;
    }
}

