/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.graphdata;

import ikr.simtree.base.SimTreeException;
import ikr.simtree.graphdata.GraphData;
import java.util.ArrayList;
import java.util.List;

public abstract class GraphDataEval {
    public static List<String>[] getFlatDiagramData(GraphData graphData) throws SimTreeException {
        int numOfCols = graphData.getNumOfCols();
        List[] ret = new List[numOfCols];
        int col = 0;
        while (col < numOfCols) {
            ret[col] = new ArrayList(40);
            ++col;
        }
        int primaryLine = 0;
        while (primaryLine < graphData.graphContent[0].size()) {
            int thisLineSize = 1;
            int col2 = 0;
            while (col2 < numOfCols) {
                int numEntries = graphData.graphContent[col2].get(primaryLine).size();
                if (numEntries != 1) {
                    if (thisLineSize == 1) {
                        thisLineSize = numEntries;
                    } else if (thisLineSize != numEntries) {
                        throw new SimTreeException("Inhomogenous number of results in resulting matrix, invalid query");
                    }
                }
                ++col2;
            }
            int secLine = 0;
            while (secLine < thisLineSize) {
                int col3 = 0;
                while (col3 < numOfCols) {
                    if (graphData.graphContent[col3].get(primaryLine).size() == 1) {
                        ret[col3].add(graphData.graphContent[col3].get(primaryLine).get(0));
                    } else {
                        ret[col3].add(graphData.graphContent[col3].get(primaryLine).get(secLine));
                    }
                    ++col3;
                }
                ++secLine;
            }
            ++primaryLine;
        }
        return ret;
    }

    public static List<List<String>[]> getFamilyDiagramData(GraphData graphData, int colFamily) throws SimTreeException {
        ArrayList<List<String>[]> ret = new ArrayList<List<String>[]>(40);
        int numOfCols = graphData.getNumOfCols();
        List<String>[] plainArr = GraphDataEval.getFlatDiagramData(graphData);
        assert (plainArr.length == numOfCols);
        assert (colFamily >= 0 && colFamily < numOfCols);
        int line = 0;
        while (line < plainArr[0].size()) {
            String[] lineArr = new String[numOfCols];
            int col = 0;
            while (col < numOfCols) {
                lineArr[col] = plainArr[col].get(line);
                ++col;
            }
            boolean found = false;
            for (List[] listArray : ret) {
                if (!((String)listArray[colFamily].get(0)).equals(lineArr[colFamily])) continue;
                int col2 = 0;
                while (col2 < numOfCols) {
                    listArray[col2].add(lineArr[col2]);
                    ++col2;
                }
                found = true;
                break;
            }
            if (!found) {
                List[] listArray = new List[numOfCols];
                int col3 = 0;
                while (col3 < numOfCols) {
                    listArray[col3] = new ArrayList(40);
                    listArray[col3].add(lineArr[col3]);
                    ++col3;
                }
                ret.add(listArray);
            }
            ++line;
        }
        return ret;
    }
}

