/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.eval;

import ikr.simtree.base.Message;
import ikr.simtree.base.SHelpers;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.Strings;
import ikr.simtree.eval.BaseParseResult;
import ikr.simtree.eval.EvalResult;
import ikr.simtree.eval.EvalResults;
import ikr.simtree.eval.ParseResults;
import ikr.simtree.graphdata.GraphDataWriter;
import ikr.simtree.graphwriter.GraphWriterEnum;
import ikr.simtree.graphwriter.GraphWriterFactory;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.ColumnDefinitionOption;
import ikr.simtree.options.Options;
import ikr.simtree.simpara.SimPara;

public class EvalResultsWriter {
    private final EvalResults evalResults;
    private final boolean visual;
    private final SimTreeContext sc;

    public EvalResultsWriter(EvalResults evalResults, boolean visual, SimTreeContext sc) {
        this.evalResults = evalResults;
        this.visual = visual;
        this.sc = sc;
    }

    public void printResultsForQuery(String descHead) {
        for (EvalResult evalResult : this.evalResults) {
            Message.evalResult(String.valueOf(evalResult.simParaPath.toFormattedString()) + " (" + descHead + ")", this.sc);
            for (ParseResults results : evalResult.parseResultsList) {
                Message.evalResult(String.valueOf(SHelpers.indent(1)) + "Query " + results.queryName, this.sc);
                Strings resultStrings = results.toFormattedStringList(this.sc.isVerbose());
                if (resultStrings.size() != 0) {
                    for (String resStr : resultStrings) {
                        Message.resultOut(String.valueOf(SHelpers.indent(1)) + resStr, "            ");
                    }
                    continue;
                }
                Message.evalResult(String.valueOf(SHelpers.indent(1)) + "(No results found)", this.sc);
            }
        }
    }

    public void resultsForEvalToGraphData(GraphWriterEnum graphWriterEnum, String[] additionalGraphWriterArguments, Options columnDefinitionOptions) throws SimTreeException {
        GraphDataWriter graphData = new GraphDataWriter(columnDefinitionOptions.size());
        boolean createHeadline = true;
        for (EvalResult evalResult : this.evalResults) {
            String resultPathNameForBatchOrDropNumber = null;
            graphData.addDataLine();
            int col = 0;
            while (col < columnDefinitionOptions.size()) {
                ColumnDefinitionOption cdo = (ColumnDefinitionOption)columnDefinitionOptions.get(col);
                assert (cdo.getColNum() == col);
                switch (cdo.getColKind()) {
                    case SIMULATION_PARAMETER: {
                        SimPara simPara = evalResult.simParaPath.getSimParaFromName(cdo.getParaName());
                        if (simPara != null) {
                            assert (simPara.getParaName().equals(cdo.getParaName()));
                            if (createHeadline) {
                                graphData.setHeadLineStrForCol(col, simPara.getParaName());
                            }
                            graphData.addDataInCurrentLine(col, simPara.getStringValue());
                            break;
                        }
                        throw new SimTreeException("Cannot find parameter " + cdo.getParaName() + " in eval result");
                    }
                    case RESULT_PATH: {
                        String searchName = cdo.getColSearchName();
                        boolean found = false;
                        for (ParseResults results : evalResult.parseResultsList) {
                            if (!results.queryName.equals(searchName)) continue;
                            if (createHeadline) {
                                graphData.setHeadLineStrForCol(col, results.queryPath.toComposedString());
                            }
                            found = true;
                            for (BaseParseResult result : results) {
                                graphData.addDataInCurrentLine(col, result.value);
                            }
                        }
                        if (found) break;
                        throw new SimTreeException("Cannot find value for column " + cdo.getColNum());
                    }
                    case BATCH_NUMBER: 
                    case DROP_NUMBER: {
                        if (resultPathNameForBatchOrDropNumber == null) {
                            int cc = 0;
                            while (cc < columnDefinitionOptions.size()) {
                                ColumnDefinitionOption cdo2 = (ColumnDefinitionOption)columnDefinitionOptions.get(cc);
                                if (cdo2.getColKind() == ColumnDefinitionOption.ColKindEnum.RESULT_PATH) {
                                    resultPathNameForBatchOrDropNumber = cdo2.getColSearchName();
                                    break;
                                }
                                ++cc;
                            }
                            if (resultPathNameForBatchOrDropNumber == null) {
                                throw new SimTreeException("Cannot add batch or drop number without a result path column in the query");
                            }
                        }
                        assert (resultPathNameForBatchOrDropNumber != null);
                        if (createHeadline) {
                            graphData.setHeadLineStrForCol(col, cdo.getColKind() == ColumnDefinitionOption.ColKindEnum.BATCH_NUMBER ? "BatchNumber" : "DropNumber");
                        }
                        for (ParseResults results : evalResult.parseResultsList) {
                            if (!results.queryName.equals(resultPathNameForBatchOrDropNumber)) continue;
                            for (BaseParseResult result : results) {
                                graphData.addDataInCurrentLine(col, result.getSingleRunResultDef().getEvalDisplayString());
                            }
                        }
                        break;
                    }
                }
                ++col;
            }
            createHeadline = false;
        }
        GraphWriterFactory.factory(graphWriterEnum, graphData, additionalGraphWriterArguments, this.visual, this.sc).showGraph();
    }
}

