/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.control.comm;

import ikr.simtree.base.Message;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.cmdrun.CommandOutputHandler;
import ikr.simtree.control.CommandHandler;
import ikr.simtree.control.comm.ControlServerRunner;
import ikr.simtree.control.comm.HelperClientRunner;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.vfs.StudyRootVFS;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class HelperServerRunner
extends ControlServerRunner {
    protected static final String CTL_HELPER_NAME = "simtree_helper";
    protected static final String CTL_SOCKET_NAME = "socket";
    private final SimTreeContext sc;
    private boolean stopThread = false;

    protected HelperServerRunner(SimTreeContext sc) throws SimTreeException {
        this.sc = sc;
    }

    @Override
    public void startControl() throws SimTreeException {
        new Thread(new ControlThread()).start();
    }

    @Override
    public void stopControl() throws SimTreeException {
        this.stopThread = true;
        new HelperClientRunner().run("FINISH", CommandOutputHandler.simpleCommandOutputHandler, this.sc);
    }

    private class ControlThread
    implements Runnable {
        private final String[] command;

        public ControlThread() throws SimTreeException {
            String p = String.valueOf(StudyRootVFS.createAndGetControlSocketDirName()) + File.separator + HelperServerRunner.CTL_SOCKET_NAME;
            this.command = new String[]{HelperServerRunner.CTL_HELPER_NAME, "ControlServer", "--path", p, "--save-name", String.valueOf(p) + ".obsolete"};
        }

        @Override
        public void run() {
            while (!HelperServerRunner.this.stopThread) {
                ProcessBuilder pb = new ProcessBuilder(this.command);
                pb.directory(new File(StudyRootVFS.getStudyRoot()));
                Process process = null;
                try {
                    process = pb.start();
                }
                catch (IOException e) {
                    Message.errorIOException(e, "Starting command " + this.command[0], HelperServerRunner.this.sc);
                }
                if (process == null) continue;
                BufferedReader stdout = new BufferedReader(new InputStreamReader(process.getInputStream()));
                BufferedWriter stdin = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
                String request = null;
                try {
                    request = stdout.readLine();
                }
                catch (IOException e) {
                    Message.warning("Reading from control server helper failed", HelperServerRunner.this.sc);
                }
                if (request != null) {
                    try {
                        for (String s : new CommandHandler(HelperServerRunner.this.sc).handle(request).getAnswer()) {
                            stdin.write(String.valueOf(s) + "\n");
                        }
                    }
                    catch (IOException e) {
                        Message.warning("Cannot write to peer", HelperServerRunner.this.sc);
                    }
                }
                try {
                    stdin.close();
                }
                catch (IOException e) {
                    Message.errorIOException(e, "closing stdin stream", HelperServerRunner.this.sc);
                }
                try {
                    stdout.close();
                }
                catch (IOException e) {
                    Message.errorIOException(e, "closing stdout stream", HelperServerRunner.this.sc);
                }
                assert (process != null);
                try {
                    int exitValue = process.waitFor();
                    if (exitValue == 10) {
                        Message.error("Cannot start control server helper, control not available", HelperServerRunner.this.sc);
                        HelperServerRunner.this.stopThread = true;
                    }
                    if (exitValue != 0 && exitValue != 21) {
                        Message.warning("Control server helper returned " + exitValue, HelperServerRunner.this.sc);
                    }
                }
                catch (InterruptedException e) {
                    Message.warning("Interrupted exception", HelperServerRunner.this.sc);
                }
                process.destroy();
            }
        }
    }
}

