/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.control.comm;

import ikr.simtree.base.SimTreeException;
import ikr.simtree.cmdrun.CommandOutputHandler;
import ikr.simtree.cmdrun.CommandReturn;
import ikr.simtree.control.comm.ControlClientRunner;
import ikr.simtree.control.comm.DBusControlObjectSpec;
import ikr.simtree.control.comm.DBusReturnSpec;
import ikr.simtree.launch.SimTreeContext;
import org.freedesktop.dbus.DBusConnection;
import org.freedesktop.dbus.UInt32;
import org.freedesktop.dbus.exceptions.DBusException;

public class DBusClientRunner
extends ControlClientRunner {
    @Override
    public CommandReturn run(String request, CommandOutputHandler stdoutSpec, SimTreeContext sc) throws SimTreeException {
        DBusReturnSpec<String[], UInt32> remoteAnswer;
        DBusConnection dBusConnection = null;
        DBusControlObjectSpec remoteObject = null;
        try {
            dBusConnection = DBusConnection.getConnection((int)1);
            remoteObject = (DBusControlObjectSpec)dBusConnection.getRemoteObject("ikr.simtree.server", "/SimTree/Control", DBusControlObjectSpec.class);
        }
        catch (DBusException e) {
            throw new SimTreeException("DBus exception: " + e.getMessage());
        }
        assert (remoteObject != null);
        try {
            remoteAnswer = remoteObject.controlRequest(request);
        }
        catch (RuntimeException e) {
            throw new SimTreeException("DBus Runtime exeception: " + e.getMessage());
        }
        String[] stringArray = (String[])remoteAnswer.a;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            stdoutSpec.addToStringList(s);
            ++n2;
        }
        assert (dBusConnection != null);
        dBusConnection.disconnect();
        return new CommandReturn(0);
    }
}

