/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.control.channel;

import ikr.simtree.base.Helpers;
import ikr.simtree.base.Strings;
import ikr.simtree.control.channel.ChannelCommandEnum;
import ikr.simtree.control.channel.ChannelEnum;
import ikr.simtree.control.channel.ChannelMessage;
import java.util.Iterator;
import java.util.LinkedList;

public class UpstreamMessageCollector {
    private static final int MAX_MESSAGES = 1024;
    private final LinkedList<ChannelMessage> messages = new LinkedList();

    public synchronized void addMessage(String messageString) {
        ChannelMessage controlMessage;
        if (this.messages.size() > 1024) {
            this.messages.removeFirst();
        }
        if ((controlMessage = ChannelMessage.splitMessage(messageString)) == null) {
            return;
        }
        this.messages.add(controlMessage);
    }

    public synchronized Strings getChannelMessages(ChannelEnum channel, ChannelCommandEnum channelCommand) {
        Strings ret = new Strings();
        for (ChannelMessage mess : this.messages) {
            if (mess.channel != channel || mess.command != channelCommand) continue;
            ret.add(mess.toDisplayString());
        }
        return ret;
    }

    private synchronized ChannelMessage retrieveNext(ChannelEnum channel, ChannelCommandEnum channelCommand) {
        if (this.messages.size() != 0) {
            Iterator iter = this.messages.iterator();
            while (iter.hasNext()) {
                ChannelMessage mess = (ChannelMessage)iter.next();
                if (mess.channel != channel || mess.command != channelCommand) continue;
                iter.remove();
                return mess;
            }
        }
        return null;
    }

    public ChannelMessage waitAndRetrieve(ChannelEnum channel, ChannelCommandEnum channelCommand, int timeoutMilliSeconds) {
        assert (timeoutMilliSeconds > 0);
        int loops = 10;
        int msInLoop = timeoutMilliSeconds / loops;
        ChannelMessage ret = null;
        while (loops-- >= 0 && (ret = this.retrieveNext(channel, channelCommand)) == null) {
            Helpers.pauseThread(msInLoop);
        }
        return ret;
    }

    public synchronized boolean isMessageAvail(ChannelEnum channel, ChannelCommandEnum channelCommand) {
        for (ChannelMessage mess : this.messages) {
            if (mess.channel != channel || mess.command != channelCommand) continue;
            return true;
        }
        return false;
    }
}

