/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.control.channel;

import ikr.simtree.base.EnumHelpers;
import ikr.simtree.control.channel.ChannelCommandEnum;
import ikr.simtree.control.channel.ChannelEnum;
import java.text.DateFormat;
import java.util.Locale;

public class ChannelMessage {
    private static final String patternStart = "[#SimTreeControl#";
    public final ChannelEnum channel;
    public final ChannelCommandEnum command;
    public final String message;
    private final long timestamp = System.currentTimeMillis();

    public ChannelMessage(ChannelEnum channel, ChannelCommandEnum command, String message) {
        this.channel = channel;
        this.command = command;
        this.message = message;
        assert (channel != null);
        assert (message != null);
        assert (command != null);
    }

    public ChannelMessage(ChannelEnum channel, ChannelCommandEnum command) {
        this(channel, command, "");
    }

    public static ChannelMessage splitMessage(String message) {
        ChannelCommandEnum chc;
        if (!message.startsWith(patternStart)) {
            return null;
        }
        String[] msgSplit = message.split("\\Q#\\E");
        if (msgSplit.length < 5) {
            return null;
        }
        ChannelEnum ch = (ChannelEnum)EnumHelpers.matchEnum(ChannelEnum.values(), msgSplit[2]);
        if (ch == null) {
            return null;
        }
        String command = msgSplit[3];
        if (command.length() == 0) {
            chc = ChannelCommandEnum.NONE;
        } else {
            chc = (ChannelCommandEnum)EnumHelpers.matchEnum(ChannelCommandEnum.values(), command);
            if (chc == null) {
                return null;
            }
        }
        if (msgSplit[4].length() != 0 && msgSplit[4].charAt(0) != ']') {
            return null;
        }
        String msg = "";
        if (msgSplit[4].length() >= 2) {
            msg = msgSplit[4].substring(2);
        }
        return new ChannelMessage(ch, chc, msg);
    }

    public String toChannelMessageString() {
        return patternStart + this.channel.getChannelName() + "#" + (this.command == ChannelCommandEnum.NONE ? "" : this.command.getCommandName()) + "#]" + (this.message.length() == 0 ? "" : " " + this.message);
    }

    public String toDisplayString() {
        return "[" + DateFormat.getDateInstance(2, Locale.GERMAN).format(this.timestamp) + " " + DateFormat.getTimeInstance(2, Locale.GERMAN).format(this.timestamp) + "] " + this.message;
    }
}

