/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.control;

import ikr.simtree.base.Message;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.commandline.CommandLine;
import ikr.simtree.control.ControlAnswer;
import ikr.simtree.control.ControlObjectEnum;
import ikr.simtree.control.ControlRequest;
import ikr.simtree.control.ProcsObjectCommandHandler;
import ikr.simtree.control.SlotsObjectCommandHandler;
import ikr.simtree.control.WSObjectCommandHandler;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.ControlCommandOption;
import ikr.simtree.options.OptionEnum;
import ikr.simtree.options.OptionSourceEnum;
import ikr.simtree.options.Options;

public class CommandHandler {
    private final SimTreeContext sc;

    public CommandHandler(SimTreeContext sc) {
        this.sc = sc;
    }

    public ControlAnswer handle(String request) {
        ControlAnswer answer = new ControlAnswer();
        try {
            Options options = Options.fromUnparsedOptions(new CommandLine(request.split("\\Q \\E")).getUnparsedOptions(), OptionSourceEnum.COMMAND_LINE, this.sc);
            ControlCommandOption controlCommandOption = (ControlCommandOption)options.getOption(OptionEnum.CONTROL_COMMAND);
            if (controlCommandOption == null) {
                throw new SimTreeException("Control command option not found, invalid request");
            }
            ControlRequest controlRequest = ControlObjectEnum.parse(controlCommandOption.getSingleArg(), options);
            Message.notice(controlRequest.toMessage(), this.sc);
            switch (controlRequest.controlObject) {
                case SLOTS: {
                    answer = new SlotsObjectCommandHandler().handle(controlRequest, options, this.sc);
                    break;
                }
                case WS: {
                    answer = new WSObjectCommandHandler().handle(controlRequest, options, this.sc);
                    break;
                }
                case PROCS: {
                    answer = new ProcsObjectCommandHandler().handle(controlRequest, options, this.sc);
                }
            }
        }
        catch (SimTreeException e) {
            answer.addAnswer("Error: " + e.getMessage(), 0);
            Message.warning("Cannot handle remote request [" + request + "]: (" + e.getMessage() + ")", this.sc);
        }
        return answer;
    }
}

