/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.commands;

import ikr.simtree.base.FileOPs;
import ikr.simtree.base.Helpers;
import ikr.simtree.base.Message;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.StringPairsFileReader;
import ikr.simtree.commands.CommandDesc;
import ikr.simtree.commands.WalkerCommand;
import ikr.simtree.control.ProcessList;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.LocalProcessSlotsOption;
import ikr.simtree.options.OptionEnum;
import ikr.simtree.options.Options;
import ikr.simtree.options.SingleArgOption;
import ikr.simtree.parafile.AttributesLists;
import ikr.simtree.runsim.ProcessScheduler;
import ikr.simtree.runsim.ProcessSlot;
import ikr.simtree.runsim.SimThread;
import ikr.simtree.vfs.StudyRootVFS;
import ikr.simtree.workingset.WorkItem;
import ikr.simtree.workingset.WorkingSet;
import java.io.File;

public abstract class WalkerRunSimCommand
extends WalkerCommand {
    protected String paramFileTemplateName;
    protected AttributesLists attributesLists;
    protected String filterFileName;
    private ProcessScheduler processScheduler;
    protected String simulationBinary;
    protected String simulationParameters;

    protected WalkerRunSimCommand(CommandDesc commandDesc, Options optionList, SimTreeContext sc) {
        super(commandDesc, optionList, sc, true);
    }

    private static String resolveExistingFile(SingleArgOption option, String defaultName) throws SimTreeException {
        if (option != null) {
            return StudyRootVFS.resolveFilenameToAbsolutePath(option.getSingleArg());
        }
        return defaultName;
    }

    @Override
    protected void doItStarter() throws SimTreeException {
        super.doItStarter();
        this.paramFileTemplateName = WalkerRunSimCommand.resolveExistingFile(this.getSingleArgOption(OptionEnum.PARAMETER_FILE_TEMPLATE), StudyRootVFS.getParaFileTemplateAbsName());
        assert (this.paramFileTemplateName != null);
        Message.notice("Using parameter file template " + StudyRootVFS.reduceName(this.paramFileTemplateName), this.sc);
        this.filterFileName = WalkerRunSimCommand.resolveExistingFile(this.getSingleArgOption(OptionEnum.FILTER_FILE), null);
        if (!FileOPs.isFileReadable(this.paramFileTemplateName)) {
            throw new SimTreeException("Cannot read Parameter file template " + this.paramFileTemplateName);
        }
        String absAttributeFileName = StudyRootVFS.getAttributesFileAbsName();
        if (new File(absAttributeFileName).canRead()) {
            this.attributesLists = StringPairsFileReader.readAttributesListsFile(absAttributeFileName);
            Message.notice("Using attributes file " + StudyRootVFS.reduceName(absAttributeFileName), this.sc);
        } else {
            this.attributesLists = null;
        }
        this.processScheduler = new ProcessScheduler(this.isSimTreeParent(), (LocalProcessSlotsOption)this.getOption(OptionEnum.LOCAL_PROCESS_SLOTS), this.getOptions(OptionEnum.REMOTE_PROCESS_SLOTS), this.sc);
        if (this.allowRemoteControl()) {
            this.sc.setCurrentProcessScheduler(this.processScheduler);
        }
        this.sc.setCurrentProcessList(new ProcessList());
        this.simulationBinary = ((SingleArgOption)this.getOption(OptionEnum.SIMULATION_BINARY)).getSingleArg();
        assert (this.simulationBinary != null);
        this.simulationBinary = StudyRootVFS.resolveFilenameToAbsolutePath(this.simulationBinary);
    }

    @Override
    protected void handleWorkingSet(WorkingSet workingSet) throws SimTreeException {
        boolean warnedOnNoSlots = false;
        assert (this.allowRemoteControl());
        this.sc.setCurrentWorkingSet(workingSet);
        while (true) {
            ProcessSlot processSlot = null;
            if (!workingSet.isWaitingEmpty() && (processSlot = this.processScheduler.getSlot()) == null) {
                if (!warnedOnNoSlots) {
                    warnedOnNoSlots = true;
                    Message.warning("No process slot available, add with remote control or abort program", this.sc);
                }
                Helpers.pauseThread(1000L);
                continue;
            }
            warnedOnNoSlots = false;
            WorkItem workItem = null;
            if (processSlot != null) {
                workItem = workingSet.getNextWaitingAndMoveFromWaitingToRunning();
            }
            if (workItem != null) {
                assert (processSlot != null);
                this.handleWorkItem(workItem, processSlot);
            } else if (SimThread.areSimThreadsRunning()) {
                Helpers.pauseThread(500L);
            } else if (workingSet.isWaitingEmpty()) break;
            Helpers.pauseThread(50L);
        }
    }

    abstract void handleWorkItem(WorkItem var1, ProcessSlot var2) throws SimTreeException;

    @Override
    protected void handleWorkItem(WorkItem workItem) throws SimTreeException {
        assert (false);
    }

    @Override
    protected void doItFinal() throws SimTreeException {
        super.doItFinal();
        this.processScheduler.noMoreProcessesWillBeStarted();
    }
}

