/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.commands;

import ikr.simtree.base.Message;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.commands.CommandDesc;
import ikr.simtree.commands.WalkerCommand;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.Options;
import ikr.simtree.vfs.results.node.ResultNodeVFS;
import ikr.simtree.workingset.WorkItem;

public class UnlockCommand
extends WalkerCommand {
    protected UnlockCommand(CommandDesc commandDesc, Options optionList, SimTreeContext sc) {
        super(commandDesc, optionList, sc, false);
    }

    @Override
    protected void doItFinal() throws SimTreeException {
        super.doItFinal();
        if (this.actionCount == 0) {
            Message.warning("Nothing selected to unlock", this.sc);
            Message.hint(this.getCommandDesc(), this.sc);
        } else {
            Message.notice(String.valueOf(this.actionCount) + " simulation parameter value sets unlocked", this.sc);
        }
    }

    @Override
    void handleWorkItem(WorkItem workItem) throws SimTreeException {
        this.actionCount += new ResultNodeVFS(workItem.workDesc.simParaPath, this.sc).unlockAllExistingResults();
        workItem.fromRunningToFinished();
    }
}

