/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.commands;

import ikr.simtree.base.Message;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.StringContainer;
import ikr.simtree.commands.CommandDesc;
import ikr.simtree.commands.WalkerRunSimCommand;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.Options;
import ikr.simtree.resultdef.ResultDef;
import ikr.simtree.resultdef.ResultDefs;
import ikr.simtree.runsim.ProcessSlot;
import ikr.simtree.runsim.RunSim;
import ikr.simtree.vfs.results.node.ResultNodeVFS;
import ikr.simtree.workingset.StringWorkItemInfo;
import ikr.simtree.workingset.WorkItem;

public class SimulateCommand
extends WalkerRunSimCommand {
    private ResultDefs resultDefs;

    protected SimulateCommand(CommandDesc commandDesc, Options optionList, SimTreeContext sc) {
        super(commandDesc, optionList, sc);
    }

    @Override
    protected void doItStarter() throws SimTreeException {
        super.doItStarter();
        this.resultDefs = this.getCheckedResultDefOption().getResultDefs();
        assert (this.resultDefs != null && this.resultDefs.size() != 0);
    }

    @Override
    protected ResultDefs getResultDefs() {
        return this.resultDefs;
    }

    @Override
    void handleWorkItem(WorkItem workItem, ProcessSlot processSlot) throws SimTreeException {
        ResultNodeVFS rnVFS = new ResultNodeVFS(workItem.workDesc.simParaPath, this.sc);
        ResultDef resultDef = workItem.workDesc.resultDef;
        StringContainer stringContainer = new StringContainer();
        if (rnVFS.skipSimulate(resultDef, stringContainer)) {
            Message.warning("Skipping " + workItem.workDesc.simParaPath.toFormattedString() + ", " + resultDef.getFullDisplayString() + " (" + stringContainer.getString() + ")", this.sc);
            workItem.addInfo(new StringWorkItemInfo("(Skipped)", true));
            workItem.fromRunningToFinished();
        } else {
            ++this.actionCount;
            RunSim.runSim(workItem, this.getCommandDesc().commandEnum, processSlot, rnVFS, this.simulationBinary, this.paramFileTemplateName, this.filterFileName, this.attributesLists, this.isSimTreeParent(), this.sc);
        }
    }
}

