/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.commands;

import ikr.simtree.base.Message;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.commands.CommandDesc;
import ikr.simtree.commands.WalkerCommand;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.Options;
import ikr.simtree.simpara.SimParaPath;
import ikr.simtree.vfs.results.tree.ResultsTreeVFS;
import ikr.simtree.workingset.WorkItem;

public class RemoveCommand
extends WalkerCommand {
    protected RemoveCommand(CommandDesc commandDesc, Options optionList, SimTreeContext sc) {
        super(commandDesc, optionList, sc, false);
    }

    @Override
    protected void doItFinal() throws SimTreeException {
        super.doItFinal();
        if (this.actionCount == 0) {
            Message.warning("No simulation parameter value set removed", this.sc);
            Message.hint(this.getCommandDesc(), this.sc);
        } else {
            Message.notice(String.valueOf(this.actionCount) + " simulation parameter value sets removed", this.sc);
        }
    }

    @Override
    void handleWorkItem(WorkItem workItem) throws SimTreeException {
        SimParaPath path = workItem.workDesc.simParaPath.clonePath();
        boolean removed = false;
        while (path.size() != 0) {
            if (new ResultsTreeVFS(path).rmDir() != 0) {
                removed = true;
            }
            path.remove(path.size() - 1);
        }
        if (removed) {
            ++this.actionCount;
        }
        workItem.fromRunningToFinished();
    }
}

