/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.commands;

import ikr.simtree.base.Message;
import ikr.simtree.base.SHelpers;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.commands.CommandDesc;
import ikr.simtree.commands.CommandVariantEnum;
import ikr.simtree.commands.ListLine;
import ikr.simtree.commands.ListLines;
import ikr.simtree.commands.WalkerCommand;
import ikr.simtree.gui.TabTypeEnum;
import ikr.simtree.gui.tree.ValueInTreeForList;
import ikr.simtree.gui.tree.ValueTree;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.OptionEnum;
import ikr.simtree.options.Options;
import ikr.simtree.options.PrintFormatOption;
import ikr.simtree.simpara.SimPara;
import ikr.simtree.simpara.SimParaPath;
import ikr.simtree.vfs.StudyRootVFS;
import ikr.simtree.vfs.results.node.ResultNodeVFS;
import ikr.simtree.vfs.results.tree.ResultsTreeState;
import ikr.simtree.vfs.results.tree.ResultsTreeVFS;
import ikr.simtree.workingset.WorkItem;
import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;

public class ListCommand
extends WalkerCommand {
    private String printFormat;
    private final ListLines listLines = new ListLines();

    protected ListCommand(CommandDesc commandDesc, Options optionList, SimTreeContext sc) {
        super(commandDesc, optionList, sc, true);
    }

    @Override
    protected void doItStarter() throws SimTreeException {
        super.doItStarter();
        PrintFormatOption pfo = (PrintFormatOption)this.getOption(OptionEnum.PRINT_FORMAT);
        assert (pfo != null);
        SimParaPath longestSimParaPath = ResultsTreeState.getCurrentTreeContent(this.sc).getLongestPath();
        Message.notice("Result tree contains " + longestSimParaPath.size() + " parameters", this.sc);
        for (SimPara simPara : longestSimParaPath) {
            Message.notice(String.valueOf(SHelpers.indent(1)) + "Parameter " + simPara.getParaName() + ", Type " + simPara.getTypeName(), this.sc);
        }
        this.printFormat = pfo.getFormatString();
        if (!this.hasCommandVariant(CommandVariantEnum.VISUAL)) {
            for (String helpLine : ListLine.getHeader(this.printFormat)) {
                Message.notice(helpLine, this.sc);
            }
        }
        if (!this.hasCommandVariant(CommandVariantEnum.VISUAL)) {
            Message.notice("Content of Study root", this.sc);
        }
    }

    private static ArrayList<ListLines> extractLineBlocks(ListLines fullListLines, int currentDepth) throws SimTreeException {
        ArrayList<ListLines> ret = new ArrayList<ListLines>();
        String value = null;
        ListLines currentBlock = new ListLines();
        int index = 0;
        while (index < fullListLines.size()) {
            ListLine listLine = (ListLine)fullListLines.get(index);
            SimParaPath simParaPath = listLine.simParaPath;
            if (simParaPath.size() > currentDepth) {
                SimPara simPara = (SimPara)simParaPath.get(currentDepth);
                if (value == null) {
                    value = simPara.getStringValue();
                    currentBlock.add(listLine);
                } else if (simPara.isValueEqual(value)) {
                    currentBlock.add(listLine);
                } else {
                    value = simPara.getStringValue();
                    assert (currentBlock.size() != 0);
                    ret.add(currentBlock);
                    currentBlock = new ListLines();
                    currentBlock.add(listLine);
                }
            }
            ++index;
        }
        if (currentBlock.size() != 0) {
            ret.add(currentBlock);
        }
        return ret;
    }

    private void createSubTree(DefaultMutableTreeNode currentNode, ListLines ll, int currentDepth) throws SimTreeException {
        for (ListLines localLL : ListCommand.extractLineBlocks(ll, currentDepth)) {
            int added = 0;
            SimPara simPara = (SimPara)((ListLine)localLL.get((int)0)).simParaPath.get(currentDepth);
            for (ListLine listLine : localLL) {
                if (listLine.simParaPath.size() != currentDepth + 1) continue;
                currentNode.add(new DefaultMutableTreeNode(new ValueInTreeForList(listLine.getStringForJTreeView(), listLine.getLines(), listLine.simParaPath, listLine.resultNodeContent.finalResultFileExist, listLine.getResultNamesForVisualView(), this.sc)));
                ++added;
            }
            if (added >= localLL.size()) continue;
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(new ValueInTreeForList(ListLine.getStringForJTreeView(simPara), null, null, false, null, this.sc));
            currentNode.add(newNode);
            this.createSubTree(newNode, localLL, currentDepth + 1);
        }
    }

    @Override
    protected void doItFinal() throws SimTreeException {
        super.doItFinal();
        if (this.hasCommandVariant(CommandVariantEnum.VISUAL)) {
            DefaultMutableTreeNode topNode = new DefaultMutableTreeNode(new ValueInTreeForList(StudyRootVFS.getStudyRoot(), null, null, false, null, this.sc));
            this.createSubTree(topNode, this.listLines, 0);
            ValueTree valueTree = new ValueTree(topNode, this.sc);
            valueTree.createView(TabTypeEnum.LIST_TREE, StudyRootVFS.getStudyRoot(), true);
            for (String helpLine : ListLine.getHeader(this.printFormat)) {
                Message.notice(helpLine, this.sc);
            }
        } else {
            Message.notice(String.valueOf(this.actionCount) + " simulation parameter value sets listed", this.sc);
        }
    }

    @Override
    void handleWorkItem(WorkItem workItem) throws SimTreeException {
        ListLine listLine = new ListLine(this.printFormat, this.sc);
        ResultsTreeVFS vfs = new ResultsTreeVFS(workItem.workDesc.simParaPath);
        SimParaPath simParaPath = vfs.getPathClone();
        assert (simParaPath.size() > 0);
        listLine.simParaPath = simParaPath;
        ++this.actionCount;
        listLine.setResultNodeContent(new ResultNodeVFS(simParaPath, this.sc).getResultNodeContent());
        if (this.hasCommandVariant(CommandVariantEnum.VISUAL)) {
            this.listLines.add(listLine);
        } else {
            listLine.commit();
        }
        workItem.fromRunningToFinished();
    }
}

