/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.commands;

import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.Strings;
import ikr.simtree.commandline.UnparsedOptions;
import ikr.simtree.commands.Command;
import ikr.simtree.commands.CommandDesc;
import ikr.simtree.commands.CommandEnum;
import ikr.simtree.commands.CommandGroupEnum;
import ikr.simtree.commands.CommandVariantEnum;
import ikr.simtree.control.ControlObjectEnum;
import ikr.simtree.help.HTMLFormatter;
import ikr.simtree.help.HeadLine;
import ikr.simtree.help.HelpPara;
import ikr.simtree.help.HelpParaTypeEnum;
import ikr.simtree.help.HelpParas;
import ikr.simtree.help.HelpTextExtractor;
import ikr.simtree.help.NumberGenerator;
import ikr.simtree.help.SimpleHelpPara;
import ikr.simtree.help.TextFormatter;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.OptionEnum;
import ikr.simtree.options.OptionGroupEnum;
import ikr.simtree.options.Options;

public class FullHelpCommand
extends Command {
    private static final HelpParas headLines = new HelpParas();

    private FullHelpCommand(CommandDesc commandDesc, Options optionList, SimTreeContext sc) {
        super(commandDesc, optionList, sc);
    }

    @Override
    public void doIt() {
        assert (false);
    }

    private static void addHeadLine(HelpParas helpParas, HelpPara headLine) {
        helpParas.add(headLine);
        headLines.add(headLine);
    }

    private static HelpParas getIntroAndSpecHelpParas(String topic, String subTopic, NumberGenerator nums) throws SimTreeException {
        HelpParas ret = new HelpParas();
        HelpParas sub = HelpTextExtractor.getHelpSectionParas(0, null, topic, subTopic, null);
        Strings headline = ((HelpPara)sub.get(0)).getContent();
        sub.remove(0);
        assert (headline.size() == 1);
        FullHelpCommand.addHeadLine(ret, new HeadLine(subTopic.equals("main") ? HelpParaTypeEnum.H1 : HelpParaTypeEnum.H2, nums, headline.toSingleString()));
        ret.addAll(sub);
        return ret;
    }

    private static HelpParas addMainTopic(NumberGenerator nums, CommandEnum commandEnum, String topic) throws SimTreeException {
        nums.nextL1();
        HelpParas helpParas = new HelpParas();
        helpParas.addAll(FullHelpCommand.getIntroAndSpecHelpParas(topic, "main", nums));
        helpParas.addGapAfter();
        CommandVariantEnum[] commandVariantEnumArray = commandEnum.supportedVariants;
        int n = commandEnum.supportedVariants.length;
        int n2 = 0;
        while (n2 < n) {
            CommandVariantEnum var = commandVariantEnumArray[n2];
            nums.nextL2();
            helpParas.addAll(FullHelpCommand.getIntroAndSpecHelpParas(topic, var.commandVariantName, nums));
            helpParas.addGapAfter();
            ++n2;
        }
        return helpParas;
    }

    public static void doItStatic(CommandDesc commandDesc, UnparsedOptions unparsedOptions) throws SimTreeException {
        int n;
        int n2;
        Enum[] enumArray;
        HelpParas helpParas = new HelpParas();
        NumberGenerator nums = new NumberGenerator();
        helpParas.addAll(FullHelpCommand.addMainTopic(nums, CommandEnum.INTRO, "intro"));
        nums.nextL1();
        FullHelpCommand.addHeadLine(helpParas, new HeadLine(HelpParaTypeEnum.H1, nums, "SimTree Commands"));
        nums.nextL2();
        FullHelpCommand.addHeadLine(helpParas, new HeadLine(HelpParaTypeEnum.H2, nums, "Command Overview"));
        helpParas.addAll(CommandEnum.getAllListHelp(0));
        helpParas.addGapAfter();
        Enum[] enumArray2 = CommandGroupEnum.values();
        int n3 = enumArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            CommandGroupEnum commandGroup = enumArray2[n4];
            if (commandGroup != CommandGroupEnum.INTERNAL) {
                nums.nextL2();
                FullHelpCommand.addHeadLine(helpParas, new HeadLine(HelpParaTypeEnum.H2, nums, commandGroup.helpText));
                enumArray = CommandEnum.values();
                n2 = enumArray.length;
                n = 0;
                while (n < n2) {
                    CommandEnum commandEnum = enumArray[n];
                    if (commandEnum.commandGroup == commandGroup) {
                        nums.nextL3();
                        FullHelpCommand.addHeadLine(helpParas, new HeadLine(HelpParaTypeEnum.H3, nums, commandEnum.getCrossRef(), "Command " + commandEnum.commandName));
                        helpParas.addAll(commandEnum.getFullHelp());
                        helpParas.addGapAfter();
                    }
                    ++n;
                }
            }
            ++n4;
        }
        nums.nextL1();
        FullHelpCommand.addHeadLine(helpParas, new HeadLine(HelpParaTypeEnum.H1, nums, "SimTree Options"));
        nums.nextL2();
        FullHelpCommand.addHeadLine(helpParas, new HeadLine(HelpParaTypeEnum.H2, nums, "Options Overview"));
        helpParas.addAll(OptionEnum.getAllListHelp(0));
        enumArray2 = OptionGroupEnum.values();
        n3 = enumArray2.length;
        n4 = 0;
        while (n4 < n3) {
            Enum optionGroup = enumArray2[n4];
            if (optionGroup != OptionGroupEnum.INTERNAL) {
                nums.nextL2();
                FullHelpCommand.addHeadLine(helpParas, new HeadLine(HelpParaTypeEnum.H2, nums, ((OptionGroupEnum)optionGroup).helpText));
                enumArray = OptionEnum.values();
                n2 = enumArray.length;
                n = 0;
                while (n < n2) {
                    Enum optionEnum = enumArray[n];
                    if (((OptionEnum)optionEnum).optionGroupEnum == optionGroup && ((OptionEnum)optionEnum).isVisible) {
                        nums.nextL3();
                        FullHelpCommand.addHeadLine(helpParas, new HeadLine(HelpParaTypeEnum.H3, nums, ((OptionEnum)optionEnum).getCrossRef(), "Option " + ((OptionEnum)optionEnum).longNameWithStarter));
                        helpParas.addAll(((OptionEnum)optionEnum).getFullHelp(0));
                        helpParas.addGapAfter();
                        helpParas.addGapAfter();
                    }
                    ++n;
                }
            }
            ++n4;
        }
        helpParas.addAll(FullHelpCommand.addMainTopic(nums, CommandEnum.ADVANCED, "advanced"));
        helpParas.addAll(FullHelpCommand.addMainTopic(nums, CommandEnum.SPEC, "spec"));
        nums.nextL1();
        FullHelpCommand.addHeadLine(helpParas, new HeadLine(HelpParaTypeEnum.H1, nums, "Control"));
        nums.nextL2();
        FullHelpCommand.addHeadLine(helpParas, new HeadLine(HelpParaTypeEnum.H2, nums, "Control overview"));
        helpParas.addAll(HelpTextExtractor.getHelpSectionParas(0, null, "control", "main", null));
        nums.nextL2();
        FullHelpCommand.addHeadLine(helpParas, new HeadLine(HelpParaTypeEnum.H2, nums, "Control reference"));
        helpParas.addAll(HelpTextExtractor.getHelpSectionParas(0, null, "control", "reference", null));
        enumArray2 = ControlObjectEnum.values();
        n3 = enumArray2.length;
        n4 = 0;
        while (n4 < n3) {
            Enum controlObject = enumArray2[n4];
            nums.nextL3();
            FullHelpCommand.addHeadLine(helpParas, new HeadLine(HelpParaTypeEnum.H3, nums, "Control object " + controlObject.name().toLowerCase()));
            helpParas.addAll(((ControlObjectEnum)controlObject).getFullHelp(0));
            helpParas.addGapAfter();
            helpParas.addGapAfter();
            ++n4;
        }
        HelpParas header = new HelpParas();
        header.add(new SimpleHelpPara(HelpParaTypeEnum.H1, 0, "Documentation for SimTree (Version 2.7.0beta16)"));
        header.addAll(1, headLines.toTOCHelpParas());
        header.addGapAfter();
        helpParas.addAll(0, header);
        if (commandDesc.commandVariantEnum == CommandVariantEnum.HTML) {
            new HTMLFormatter(helpParas).print();
        } else {
            new TextFormatter(helpParas).print();
        }
    }
}

