/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.commands;

import ikr.simtree.base.Message;
import ikr.simtree.base.SHelpers;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.commands.CommandDesc;
import ikr.simtree.commands.CommandVariantEnum;
import ikr.simtree.commands.WalkerCommand;
import ikr.simtree.eval.ResultFile;
import ikr.simtree.eval.ResultFiles;
import ikr.simtree.graphwriter.PrintServerPath;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.MaxDepthOption;
import ikr.simtree.options.OptionEnum;
import ikr.simtree.options.Options;
import ikr.simtree.options.ResultDefOption;
import ikr.simtree.options.ResultPathOption;
import ikr.simtree.parser.ResultFileParser;
import ikr.simtree.parser.ResultFilesParser;
import ikr.simtree.query.ParserDumpHandler;
import ikr.simtree.resultdef.ResultDef;
import ikr.simtree.resultdef.ResultDefs;
import ikr.simtree.simpara.SimParaPath;
import ikr.simtree.vfs.results.node.ResultNodeVFS;
import ikr.simtree.workingset.WorkItem;
import java.io.File;

public class DumpCommand
extends WalkerCommand {
    private ResultDefs resultDefs;
    private PrintServerPath printServerPath;
    private int maxDepth;
    private int numberOfVisualDumps = 0;
    private boolean hasWarnedTooManyDumps;
    private static final int MAX_NUMBER_OF_VISUAL_DUMPS = 6;

    protected DumpCommand(CommandDesc commandDesc, Options optionList, SimTreeContext sc) {
        super(commandDesc, optionList, sc, true);
    }

    @Override
    protected void doItStarter() throws SimTreeException {
        super.doItStarter();
        ResultDefOption resultDefOption = this.getCheckedResultDefOption();
        if (resultDefOption != null) {
            this.resultDefs = resultDefOption.getResultDefs();
            if (this.resultDefs.size() != 1 || ((ResultDef)this.resultDefs.get(0)).getPartTestCount() != 1) {
                throw new SimTreeException("Cannot dump more than one result");
            }
        }
        this.maxDepth = -1;
        MaxDepthOption mdOption = (MaxDepthOption)this.getOption(OptionEnum.MAX_DEPTH);
        if (mdOption != null) {
            this.maxDepth = mdOption.getMaxDepth();
        }
        if (this.hasCommandVariant(CommandVariantEnum.VISUAL) && mdOption != null) {
            throw new SimTreeException("Cannot handle visual view with Option" + OptionEnum.MAX_DEPTH.hlp10);
        }
        Options resultSourcesOptions = this.getOptions(OptionEnum.RESULT_PATH);
        if (resultSourcesOptions.size() > 1) {
            throw new SimTreeException("Only one result path allowed for dump command");
        }
        this.printServerPath = resultSourcesOptions.size() == 1 ? ((ResultPathOption)resultSourcesOptions.get(0)).getResultSource().getExpandedPath() : new PrintServerPath(".*");
    }

    @Override
    void handleWorkItem(WorkItem workItem) throws SimTreeException {
        if (this.hasCommandVariant(CommandVariantEnum.VISUAL) && this.numberOfVisualDumps >= 6) {
            if (!this.hasWarnedTooManyDumps) {
                Message.warning("Too many visual dumps (use" + OptionEnum.SIMULATION_PARAMETER.hlp11 + "or" + OptionEnum.SIMULATION_PARAMETER_PATH.hlp11 + "option to restrict parameter values)", this.sc);
            }
            this.hasWarnedTooManyDumps = true;
            return;
        }
        SimParaPath simParaPath = workItem.workDesc.simParaPath;
        ResultNodeVFS rnVFS = new ResultNodeVFS(simParaPath, this.sc);
        String header = String.valueOf(simParaPath.toFormattedString()) + (this.resultDefs != null ? " " + this.resultDefs.toDisplayString() : " (FinalResults)");
        ParserDumpHandler parserDumpHandler = new ParserDumpHandler(header, this.hasCommandVariant(CommandVariantEnum.VISUAL), this.printServerPath, SHelpers.indent(1), this.maxDepth, this.sc);
        if (this.resultDefs != null) {
            ResultFiles resultFiles = rnVFS.getExistingResultFiles(this.resultDefs);
            if (resultFiles.size() == 0) {
                throw new SimTreeException("No results found");
            }
            assert (resultFiles.size() == 1);
            ResultFile resultFile = (ResultFile)resultFiles.get(0);
            ResultFilesParser.parseResultFile(resultFile.file, new ResultFileParser(resultFile, parserDumpHandler, this.sc));
        } else {
            File resultFile = rnVFS.getFinalResultsFile();
            if (resultFile != null && resultFile.exists()) {
                ResultFilesParser.parseResultFile(resultFile, new ResultFileParser(new ResultFile(resultFile), parserDumpHandler, this.sc));
            }
        }
        ++this.numberOfVisualDumps;
        workItem.fromRunningToFinished();
    }
}

