/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.commands;

import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.StringPair;
import ikr.simtree.commands.CommandGroupEnum;
import ikr.simtree.commands.CommandVariantEnum;
import ikr.simtree.help.CrossRef;
import ikr.simtree.help.CrossRefEnum;
import ikr.simtree.help.HelpParaTypeEnum;
import ikr.simtree.help.HelpParas;
import ikr.simtree.help.HelpTextExtractor;
import ikr.simtree.help.SimpleHelpPara;
import ikr.simtree.help.TwoColHelpPara;
import ikr.simtree.options.OptionEnum;
import java.util.ArrayList;

public final class CommandEnum
extends Enum<CommandEnum> {
    public static final /* enum */ CommandEnum INTRO = new CommandEnum(CommandGroupEnum.HELP, false, null, null, null, new CommandVariantEnum[]{CommandVariantEnum.COMMANDLINE, CommandVariantEnum.STARTUP, CommandVariantEnum.PARAMETERS, CommandVariantEnum.METHODS, CommandVariantEnum.RUN, CommandVariantEnum.EVAL, CommandVariantEnum.EXAMPLES, CommandVariantEnum.FIRST_STEPS, CommandVariantEnum.BUGS, CommandVariantEnum.DOC, CommandVariantEnum.HINTS});
    public static final /* enum */ CommandEnum SPEC = new CommandEnum(CommandGroupEnum.HELP, false, null, null, null, new CommandVariantEnum[]{CommandVariantEnum.WORDING, CommandVariantEnum.GOALS, CommandVariantEnum.CONSISTENCY, CommandVariantEnum.EXECUTE, CommandVariantEnum.SPECIALS});
    public static final /* enum */ CommandEnum ADVANCED = new CommandEnum(CommandGroupEnum.HELP, false, null, null, null, new CommandVariantEnum[]{CommandVariantEnum.CONFIGURATION, CommandVariantEnum.PROPERTIES, CommandVariantEnum.SYSTEM, CommandVariantEnum.HOOKS, CommandVariantEnum.ATTRIBUTES});
    public static final /* enum */ CommandEnum HELP = new CommandEnum(CommandGroupEnum.HELP, false, null, null, null);
    public static final /* enum */ CommandEnum FULLHELP = new CommandEnum(CommandGroupEnum.INTERNAL, false, null, null, null, new CommandVariantEnum[]{CommandVariantEnum.TEXT, CommandVariantEnum.HTML});
    public static final /* enum */ CommandEnum NEWS = new CommandEnum(CommandGroupEnum.HELP, false, null, null, null);
    public static final /* enum */ CommandEnum GUI = new CommandEnum(CommandGroupEnum.GUI, false, null, null, null);
    public static final /* enum */ CommandEnum PREPARE = new CommandEnum(CommandGroupEnum.TREE_HANDLING, false, null, null, null);
    public static final /* enum */ CommandEnum LIST = new CommandEnum(CommandGroupEnum.TREE_HANDLING, false, new OptionEnum[]{OptionEnum.SIMULATION_PARAMETER, OptionEnum.SIMULATION_PARAMETER_PATH}, new OptionEnum[]{OptionEnum.PRINT_FORMAT}, null, new CommandVariantEnum[]{CommandVariantEnum.VISUAL});
    public static final /* enum */ CommandEnum ADD = new CommandEnum(CommandGroupEnum.TREE_HANDLING, false, new OptionEnum[]{OptionEnum.SIMULATION_PARAMETER, OptionEnum.SIMULATION_PARAMETER_PATH}, null, null);
    public static final /* enum */ CommandEnum REMOVE = new CommandEnum(CommandGroupEnum.TREE_HANDLING, false, new OptionEnum[]{OptionEnum.SIMULATION_PARAMETER, OptionEnum.SIMULATION_PARAMETER_PATH, OptionEnum.FORCE_ALL_VALUES}, null, null);
    public static final /* enum */ CommandEnum CLEAN = new CommandEnum(CommandGroupEnum.TREE_HANDLING, false, new OptionEnum[]{OptionEnum.SIMULATION_PARAMETER, OptionEnum.SIMULATION_PARAMETER_PATH, OptionEnum.FORCE_ALL_VALUES, OptionEnum.FORCE_DELETE_FOREIGN_FILES}, null, null);
    public static final /* enum */ CommandEnum UNLOCK = new CommandEnum(CommandGroupEnum.TREE_HANDLING, false, new OptionEnum[]{OptionEnum.SIMULATION_PARAMETER, OptionEnum.SIMULATION_PARAMETER_PATH, OptionEnum.FORCE_ALL_VALUES}, null, null);
    public static final /* enum */ CommandEnum SIMULATE = new CommandEnum(CommandGroupEnum.RUN_SIMULATION, true, new OptionEnum[]{OptionEnum.SIMULATION_PARAMETER, OptionEnum.SIMULATION_PARAMETER_PATH, OptionEnum.LOCAL_PROCESS_SLOTS, OptionEnum.REMOTE_PROCESS_SLOTS, OptionEnum.FILTER_FILE, OptionEnum.PARAMETER_FILE_TEMPLATE, OptionEnum.CHILD}, new OptionEnum[]{OptionEnum.SIMULATION_BINARY}, new OptionEnum[][]{{OptionEnum.LOCAL_PROCESS_SLOTS, OptionEnum.REMOTE_PROCESS_SLOTS}, {OptionEnum.DROPS, OptionEnum.BATCHES}});
    public static final /* enum */ CommandEnum COLLECT = new CommandEnum(CommandGroupEnum.RUN_SIMULATION, true, new OptionEnum[]{OptionEnum.SIMULATION_PARAMETER, OptionEnum.SIMULATION_PARAMETER_PATH, OptionEnum.PARAMETER_FILE_TEMPLATE, OptionEnum.FILTER_FILE, OptionEnum.CHILD}, new OptionEnum[]{OptionEnum.SIMULATION_BINARY}, new OptionEnum[][]{{OptionEnum.LOCAL_PROCESS_SLOTS, OptionEnum.REMOTE_PROCESS_SLOTS}});
    public static final /* enum */ CommandEnum QUERY = new CommandEnum(CommandGroupEnum.RESULT_HANDLING, false, new OptionEnum[]{OptionEnum.SIMULATION_PARAMETER, OptionEnum.SIMULATION_PARAMETER_PATH, OptionEnum.BATCHES, OptionEnum.DROPS}, new OptionEnum[]{OptionEnum.RESULT_PATH}, null);
    public static final /* enum */ CommandEnum EVAL = new CommandEnum(CommandGroupEnum.RESULT_HANDLING, false, new OptionEnum[]{OptionEnum.SIMULATION_PARAMETER, OptionEnum.SIMULATION_PARAMETER_PATH, OptionEnum.RESULT_PATH, OptionEnum.GRAPH_WRITER, OptionEnum.BATCHES, OptionEnum.DROPS}, new OptionEnum[]{OptionEnum.COLUMN_DEFINITION}, null, new CommandVariantEnum[]{CommandVariantEnum.VISUAL});
    public static final /* enum */ CommandEnum DUMP = new CommandEnum(CommandGroupEnum.RESULT_HANDLING, false, new OptionEnum[]{OptionEnum.MAX_DEPTH, OptionEnum.SIMULATION_PARAMETER, OptionEnum.SIMULATION_PARAMETER_PATH, OptionEnum.RESULT_PATH, OptionEnum.BATCHES, OptionEnum.DROPS}, null, null, new CommandVariantEnum[]{CommandVariantEnum.VISUAL});
    public static final /* enum */ CommandEnum CONTROL = new CommandEnum(CommandGroupEnum.MANAGEMENT, false, new OptionEnum[]{OptionEnum.LOCAL_PROCESS_SLOTS, OptionEnum.REMOTE_PROCESS_SLOTS, OptionEnum.SIMULATION_PARAMETER, OptionEnum.SIMULATION_PARAMETER_PATH, OptionEnum.BATCHES, OptionEnum.DROPS}, new OptionEnum[]{OptionEnum.CONTROL_COMMAND}, null);
    public static final /* enum */ CommandEnum NULL = new CommandEnum(CommandGroupEnum.MISC, false, OptionEnum.values(), null, null);
    public static final /* enum */ CommandEnum EXEC = new CommandEnum(CommandGroupEnum.INTERNAL, false, null, new OptionEnum[]{OptionEnum.IGNORE_DEFAULT_CONFIG, OptionEnum.WORKING_DIRECTORY, OptionEnum.CHILD}, null);
    public static final OptionEnum[] alwaysValidOptions;
    public final String commandName;
    public final boolean allowRemoteControl;
    public final CommandGroupEnum commandGroup;
    public final CommandVariantEnum[] supportedVariants;
    public final OptionEnum[] validOptions;
    public final OptionEnum[] requiredOptions;
    public final OptionEnum[][] requiredOneOfOptions;
    private static final /* synthetic */ CommandEnum[] ENUM$VALUES;

    static {
        ENUM$VALUES = new CommandEnum[]{INTRO, SPEC, ADVANCED, HELP, FULLHELP, NEWS, GUI, PREPARE, LIST, ADD, REMOVE, CLEAN, UNLOCK, SIMULATE, COLLECT, QUERY, EVAL, DUMP, CONTROL, NULL, EXEC};
        alwaysValidOptions = new OptionEnum[]{OptionEnum.IGNORE_DEFAULT_CONFIG, OptionEnum.REPLACE_CONFIG, OptionEnum.SAVE_CONFIG, OptionEnum.LOAD_CONFIG, OptionEnum.VERBOSE, OptionEnum.VERY_VERBOSE, OptionEnum.STUDY_ROOT};
    }

    private CommandEnum(CommandGroupEnum commandGroup, boolean allowRemoteControl, OptionEnum[] validOptions, OptionEnum[] requiredOptions, OptionEnum[][] requiredOneOfOptions, CommandVariantEnum[] supportedVariants) {
        this.allowRemoteControl = allowRemoteControl;
        this.commandName = this.toString().toLowerCase();
        this.commandGroup = commandGroup;
        assert (supportedVariants != null);
        this.supportedVariants = supportedVariants;
        this.validOptions = validOptions == null ? new OptionEnum[0] : validOptions;
        this.requiredOptions = requiredOptions == null ? new OptionEnum[0] : requiredOptions;
        this.requiredOneOfOptions = requiredOneOfOptions == null ? new OptionEnum[0][0] : requiredOneOfOptions;
    }

    private CommandEnum(CommandGroupEnum commandGroup, boolean allowRemoteControl, OptionEnum[] validOptions, OptionEnum[] requiredOptions, OptionEnum[][] requiredOneOfOptions) {
        this(commandGroup, allowRemoteControl, validOptions, requiredOptions, requiredOneOfOptions, new CommandVariantEnum[0]);
    }

    public static CommandEnum getCommandEnumFromName(String commandName) {
        CommandEnum[] commandEnumArray = CommandEnum.values();
        int n = commandEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            CommandEnum e = commandEnumArray[n2];
            if (e.commandName.equals(commandName)) {
                return e;
            }
            ++n2;
        }
        return null;
    }

    public boolean isValidVariant(CommandVariantEnum commandVariantEnum) {
        if (commandVariantEnum == null) {
            return true;
        }
        CommandVariantEnum[] commandVariantEnumArray = this.supportedVariants;
        int n = this.supportedVariants.length;
        int n2 = 0;
        while (n2 < n) {
            CommandVariantEnum e = commandVariantEnumArray[n2];
            if (commandVariantEnum == e) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public HelpParas getFullHelp() throws SimTreeException {
        OptionEnum opt;
        int n;
        int n2;
        Enum[] enumArray;
        HelpParas ret = new HelpParas();
        ret.add(new SimpleHelpPara(HelpParaTypeEnum.H4, 0, "Usage: SimTree " + this.commandName + " <options>"));
        ret.addGapAfter();
        ret.addAll(HelpTextExtractor.getHelpSectionParas(0, "Command description", "commands", this.commandName, "desc"));
        if (this.requiredOptions.length != 0 || this.requiredOneOfOptions.length != 0) {
            ret.add(new SimpleHelpPara(HelpParaTypeEnum.H4, 0, "Required options"));
            if (this.requiredOptions.length != 0) {
                ArrayList<OptionEnum> options = new ArrayList<OptionEnum>();
                enumArray = this.requiredOptions;
                n2 = this.requiredOptions.length;
                n = 0;
                while (n < n2) {
                    OptionEnum o = enumArray[n];
                    if (o.isVisible) {
                        options.add(o);
                    }
                    ++n;
                }
                ret.add(OptionEnum.getShortHelpForOptionList(options, 1));
            }
            if (this.requiredOneOfOptions.length != 0) {
                OptionEnum[][] optionEnumArray = this.requiredOneOfOptions;
                n = this.requiredOneOfOptions.length;
                int o = 0;
                while (o < n) {
                    OptionEnum[] oo = optionEnumArray[o];
                    ArrayList<OptionEnum> options = new ArrayList<OptionEnum>();
                    ret.add(new SimpleHelpPara(HelpParaTypeEnum.H4, 1, "One of the following options"));
                    OptionEnum[] optionEnumArray2 = oo;
                    int n3 = oo.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        OptionEnum o2 = optionEnumArray2[n4];
                        if (o2.isVisible) {
                            options.add(o2);
                        }
                        ++n4;
                    }
                    ret.add(OptionEnum.getShortHelpForOptionList(options, 2));
                    ++o;
                }
            }
            ret.addGapAfter();
        }
        ArrayList<OptionEnum> oList = new ArrayList<OptionEnum>();
        enumArray = this.validOptions;
        n2 = this.validOptions.length;
        n = 0;
        while (n < n2) {
            opt = enumArray[n];
            if (!oList.contains((Object)opt) && opt.isVisible) {
                oList.add(opt);
            }
            ++n;
        }
        enumArray = alwaysValidOptions;
        n2 = alwaysValidOptions.length;
        n = 0;
        while (n < n2) {
            opt = enumArray[n];
            if (!oList.contains((Object)opt) && opt.isVisible) {
                oList.add(opt);
            }
            ++n;
        }
        ret.add(new SimpleHelpPara(HelpParaTypeEnum.H4, 0, "Accepted options"));
        ret.add(OptionEnum.getShortHelpForOptionList(oList, 1));
        ret.addGapAfter();
        ret.add(new SimpleHelpPara(HelpParaTypeEnum.E0, 0, "Type SimTree help --<option-name> to get help for an option"));
        ret.addGapAfter();
        if (this.supportedVariants.length != 0) {
            ret.add(new SimpleHelpPara(HelpParaTypeEnum.E0, 0, "Valid command variants are (use SimTree " + this.commandName + "-<Variant>)"));
            enumArray = this.supportedVariants;
            n2 = this.supportedVariants.length;
            n = 0;
            while (n < n2) {
                Enum e = enumArray[n];
                ret.add(new TwoColHelpPara(HelpParaTypeEnum.E0, 1, new StringPair(((CommandVariantEnum)e).commandVariantName, HelpTextExtractor.getHelpTextLine("commands", String.valueOf(this.commandName) + "-" + ((CommandVariantEnum)e).commandVariantName, "short")), 26));
                ++n;
            }
            ret.addGapAfter();
        }
        ret.addAll(HelpTextExtractor.getHelpSectionParas(0, "Examples", "commands", this.commandName, "examples"));
        ret.addAll(HelpTextExtractor.getHelpSectionParas(0, "Hints", "commands", this.commandName, "hints"));
        return ret;
    }

    public static HelpParas getAllListHelp(int indent) throws SimTreeException {
        HelpParas ret = new HelpParas();
        ret.add(new SimpleHelpPara(HelpParaTypeEnum.E0, indent, "Usage: SimTree <command> <options>"));
        ret.addGapAfter();
        ret.add(new SimpleHelpPara(HelpParaTypeEnum.E0, indent, "The following commands are defined"));
        CommandGroupEnum[] commandGroupEnumArray = CommandGroupEnum.values();
        int n = commandGroupEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            CommandGroupEnum commandGroupEnum = commandGroupEnumArray[n2];
            if (commandGroupEnum != CommandGroupEnum.INTERNAL) {
                ret.add(new SimpleHelpPara(HelpParaTypeEnum.H4, indent + 1, commandGroupEnum.helpText));
                TwoColHelpPara helpPara = new TwoColHelpPara(HelpParaTypeEnum.E0, indent + 2, 10);
                CommandEnum[] commandEnumArray = CommandEnum.values();
                int n3 = commandEnumArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    CommandEnum commandEnum = commandEnumArray[n4];
                    if (commandEnum.commandGroup == commandGroupEnum) {
                        helpPara.addLine(String.valueOf(CrossRefEnum.COMMAND.tag) + commandEnum.commandName, HelpTextExtractor.getHelpTextLine("commands", commandEnum.commandName, "short"));
                    }
                    ++n4;
                }
                ret.add(helpPara);
                ret.addGapAfter();
            }
            ++n2;
        }
        ret.add(new SimpleHelpPara(HelpParaTypeEnum.E0, indent, "Type 'SimTree intro' to get an introduction to SimTree"));
        ret.add(new SimpleHelpPara(HelpParaTypeEnum.E0, indent, "Type 'SimTree <command> --help' to get help for a command"));
        ret.add(new SimpleHelpPara(HelpParaTypeEnum.E0, indent, "Type 'SimTree help --<option>' to get help for an option"));
        ret.addGapAfter();
        return ret;
    }

    public CrossRef getCrossRef() {
        return new CrossRef(CrossRefEnum.COMMAND, this.commandName);
    }

    public static String replaceXrefMarks(String line) throws SimTreeException {
        String ret = line;
        if (ret.contains(CrossRefEnum.COMMAND.tag)) {
            CommandEnum[] commandEnumArray = CommandEnum.values();
            int n = commandEnumArray.length;
            int n2 = 0;
            while (n2 < n) {
                CommandEnum commandEnum = commandEnumArray[n2];
                ret = ret.replaceAll("\\Q" + CrossRefEnum.COMMAND.tag + commandEnum.commandName + "\\E", String.valueOf(commandEnum.getCrossRef().toHTMLRefStart()) + commandEnum.commandName + CrossRef.toHTMLRefEnd());
                ++n2;
            }
            if (ret.contains(CrossRefEnum.COMMAND.tag)) {
                throw new SimTreeException("Invalid cross reference in help string [" + line + "]");
            }
        }
        return ret;
    }

    public static CommandEnum[] values() {
        CommandEnum[] commandEnumArray = ENUM$VALUES;
        int n = commandEnumArray.length;
        CommandEnum[] commandEnumArray2 = new CommandEnum[n];
        System.arraycopy(ENUM$VALUES, 0, commandEnumArray2, 0, n);
        return commandEnumArray2;
    }

    public static CommandEnum valueOf(String string) {
        return Enum.valueOf(CommandEnum.class, string);
    }
}

