/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.commands;

import ikr.simtree.base.Message;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.StringContainer;
import ikr.simtree.commands.CommandDesc;
import ikr.simtree.commands.WalkerRunSimCommand;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.Options;
import ikr.simtree.runsim.ProcessSlot;
import ikr.simtree.runsim.RunSim;
import ikr.simtree.vfs.results.node.ResultNodeVFS;
import ikr.simtree.workingset.StringWorkItemInfo;
import ikr.simtree.workingset.WorkItem;

public class CollectCommand
extends WalkerRunSimCommand {
    protected CollectCommand(CommandDesc commandDesc, Options optionList, SimTreeContext sc) {
        super(commandDesc, optionList, sc);
    }

    @Override
    void handleWorkItem(WorkItem workItem, ProcessSlot processSlot) throws SimTreeException {
        ResultNodeVFS rnVFS = new ResultNodeVFS(workItem.workDesc.simParaPath, this.sc);
        StringContainer stringContainer = new StringContainer();
        assert (workItem.workDesc.resultDef == null);
        if (rnVFS.skipCollect(stringContainer)) {
            Message.warning("Skipping " + workItem.workDesc.simParaPath.toFormattedString() + " (" + stringContainer.getString() + ")", this.sc);
            workItem.addInfo(new StringWorkItemInfo("(Skipped)", true));
            workItem.fromRunningToFinished();
        } else {
            ++this.actionCount;
            RunSim.runSim(workItem, this.getCommandDesc().commandEnum, processSlot, rnVFS, this.simulationBinary, this.paramFileTemplateName, this.filterFileName, this.attributesLists, this.isSimTreeParent(), this.sc);
        }
    }
}

