/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.commands;

import ikr.simtree.base.Message;
import ikr.simtree.base.SimTreeException;
import ikr.simtree.commands.CommandDesc;
import ikr.simtree.commands.WalkerCommand;
import ikr.simtree.launch.SimTreeContext;
import ikr.simtree.options.OptionEnum;
import ikr.simtree.options.Options;
import ikr.simtree.vfs.results.node.ResultNodeVFS;
import ikr.simtree.workingset.WorkItem;

public class CleanCommand
extends WalkerCommand {
    private boolean allDone;

    protected CleanCommand(CommandDesc commandDesc, Options optionList, SimTreeContext sc) {
        super(commandDesc, optionList, sc, false);
    }

    @Override
    protected void doItStarter() throws SimTreeException {
        super.doItStarter();
        this.allDone = true;
    }

    @Override
    protected void doItFinal() throws SimTreeException {
        super.doItFinal();
        if (this.actionCount == 0) {
            Message.warning("Nothing selected to clean", this.sc);
            Message.hint(this.getCommandDesc(), this.sc);
        } else {
            Message.notice("Results for " + this.actionCount + " simulation parameter value sets cleaned", this.sc);
        }
        if (!this.allDone) {
            Message.warning("Not all results could be removed, maybe directory was locked, use SimTree unlock", this.sc);
        }
    }

    @Override
    void handleWorkItem(WorkItem workItem) throws SimTreeException {
        ResultNodeVFS bvfs = new ResultNodeVFS(workItem.workDesc.simParaPath, this.sc);
        if (this.isBoolOptionSet(OptionEnum.FORCE_DELETE_FOREIGN_FILES)) {
            if (!bvfs.completelyCleanDirectory()) {
                this.allDone = false;
            }
        } else if (!bvfs.removeAllExistingResults()) {
            this.allDone = false;
        }
        ++this.actionCount;
        workItem.fromRunningToFinished();
    }
}

