/*
 * Decompiled with CFR 0.152.
 */
package ikr.simtree.commandline;

import ikr.simtree.base.SimTreeException;
import ikr.simtree.base.Strings;
import ikr.simtree.commandline.UnparsedOption;
import ikr.simtree.commandline.UnparsedOptions;

public class CommandLine {
    private String command = "";
    private final UnparsedOptions unparsedOptions = new UnparsedOptions();

    public CommandLine(String[] args) throws SimTreeException {
        String[] cmdArgs = new String[args.length];
        int i = 0;
        while (i < args.length) {
            String trans = args[i];
            if (trans.startsWith("'")) {
                trans = trans.substring(1);
            }
            if (trans.endsWith("'")) {
                trans = trans.substring(0, trans.length() - 1);
            }
            cmdArgs[i] = trans;
            ++i;
        }
        int current = 0;
        if (cmdArgs.length == 0) {
            return;
        }
        if (!cmdArgs[0].startsWith("--")) {
            this.command = cmdArgs[0];
            current = 1;
        }
        boolean inOption = false;
        String optionName = null;
        Strings optionArguments = new Strings();
        while (current < cmdArgs.length) {
            if (cmdArgs[current].startsWith("--")) {
                inOption = true;
                this.addUnparsedOption(optionName, optionArguments);
                optionName = cmdArgs[current].substring("--".length());
                if (optionName.length() == 0) {
                    throw new SimTreeException("Invalid empty option --");
                }
                optionArguments = new Strings();
            } else {
                if (!inOption) {
                    throw new SimTreeException("Expected option (starting with --) as argument after the command " + cmdArgs[current]);
                }
                optionArguments.add(cmdArgs[current]);
            }
            ++current;
        }
        this.addUnparsedOption(optionName, optionArguments);
    }

    private void addUnparsedOption(String optionName, Strings optionArguments) {
        if (optionName != null) {
            this.unparsedOptions.add(new UnparsedOption(optionName, optionArguments));
        }
    }

    public String getCommand() {
        assert (this.command != null);
        return this.command;
    }

    public UnparsedOptions getUnparsedOptions() {
        return this.unparsedOptions;
    }
}

